/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.ByteBufferUtils;
import org.infinispan.server.resp.serialization.CollectionSerializer;
import org.infinispan.server.resp.serialization.DoubleSerializer;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.MapSerializer;
import org.infinispan.server.resp.serialization.NestedResponseSerializer;
import org.infinispan.server.resp.serialization.PrimitiveSerializer;
import org.infinispan.server.resp.serialization.Resp3SerializerRegistry;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseSerializer;
import org.infinispan.server.resp.serialization.SerializationHint;
import org.infinispan.server.resp.serialization.ThrowableSerializer;

public final class Resp3Response {
    public static final BiConsumer<Object, ByteBufPool> OK = (ignore, alloc) -> Resp3Response.ok(alloc);
    public static final BiConsumer<CharSequence, ByteBufPool> SIMPLE_STRING = Resp3Response::simpleString;
    public static final BiConsumer<byte[], ByteBufPool> BULK_STRING_BYTES = Resp3Response::string;
    public static final BiConsumer<CharSequence, ByteBufPool> BULK_STRING = Resp3Response::string;
    public static final BiConsumer<Number, ByteBufPool> INTEGER = Resp3Response::integers;
    public static final BiConsumer<Number, ByteBufPool> DOUBLE = Resp3Response::doubles;
    public static final BiConsumer<Object, ByteBufPool> UNKNOWN = Resp3Response::serialize;
    public static final BiConsumer<JavaObjectSerializer<?>, ByteBufPool> CUSTOM = (res, alloc) -> Resp3Response.write(res, alloc, res);
    public static final BiConsumer<Collection<byte[]>, ByteBufPool> ARRAY_BULK_STRING = (c, alloc) -> Resp3Response.array(c, alloc, Resp3Type.BULK_STRING);
    public static final BiConsumer<Collection<? extends Number>, ByteBufPool> ARRAY_INTEGER = (c, alloc) -> Resp3Response.array(c, alloc, Resp3Type.INTEGER);
    public static final BiConsumer<Collection<? extends Number>, ByteBufPool> ARRAY_DOUBLE = (c, alloc) -> Resp3Response.array(c, alloc, Resp3Type.DOUBLE);
    public static final BiConsumer<Set<byte[]>, ByteBufPool> SET_BULK_STRING = (s, alloc) -> Resp3Response.set(s, alloc, Resp3Type.BULK_STRING);
    public static final BiConsumer<Map<byte[], byte[]>, ByteBufPool> MAP_BULK_STRING_KV = (m, a) -> Resp3Response.map(m, a, Resp3Type.BULK_STRING);

    private Resp3Response() {
    }

    public static void nulls(ByteBufPool alloc) {
        PrimitiveSerializer.NullSerializer.INSTANCE.accept((Object)null, alloc);
    }

    public static void ok(ByteBufPool alloc) {
        Resp3Response.simpleString("OK", alloc);
    }

    public static void queued(Object ignore, ByteBufPool alloc) {
        Resp3Response.simpleString("QUEUED", alloc);
    }

    public static void simpleString(CharSequence value, ByteBufPool alloc) {
        Resp3Response.serialize(value, alloc, PrimitiveSerializer.SimpleStringSerializer.INSTANCE);
    }

    public static void string(CharSequence value, ByteBufPool alloc) {
        Resp3Response.serialize(value, alloc, PrimitiveSerializer.BulkStringSerializer2.INSTANCE);
    }

    public static void string(byte[] value, ByteBufPool alloc) {
        Resp3Response.serialize(value, alloc, PrimitiveSerializer.BulkStringSerializer.INSTANCE);
    }

    public static void integers(Number value, ByteBufPool alloc) {
        Resp3Response.serialize(value, alloc, PrimitiveSerializer.IntegerSerializer.INSTANCE);
    }

    public static void doubles(Number value, ByteBufPool alloc) {
        Resp3Response.serialize(value, alloc, DoubleSerializer.INSTANCE);
    }

    public static void booleans(boolean value, ByteBufPool alloc) {
        Resp3Response.serialize(value, alloc, PrimitiveSerializer.BooleanSerializer.INSTANCE);
    }

    public static void arrayEmpty(ByteBufPool alloc) {
        Resp3Response.write(Collections.emptyList(), alloc, (ignore, a) -> ByteBufferUtils.writeNumericPrefix((byte)42, 0L, a));
    }

    public static <T> void array(Collection<T> collection, ByteBufPool alloc, JavaObjectSerializer<T> serializer) {
        Resp3Response.serialize(collection, alloc, CollectionSerializer.ArraySerializer.INSTANCE, (o, b) -> serializer.accept(o, b));
    }

    public static void array(Collection<?> collection, ByteBufPool alloc, Resp3Type contentType) {
        Resp3Response.serialize(collection, alloc, CollectionSerializer.ArraySerializer.INSTANCE, contentType);
    }

    public static void emptySet(ByteBufPool alloc) {
        Resp3Response.write(Collections.emptySet(), alloc, (ignore, a) -> ByteBufferUtils.writeNumericPrefix((byte)126, 0L, a));
    }

    public static void set(Set<?> set, ByteBufPool alloc, Resp3Type contentType) {
        Resp3Response.serialize(set, alloc, CollectionSerializer.SetSerializer.INSTANCE, contentType);
    }

    public static void map(Map<?, ?> value, ByteBufPool alloc) {
        Resp3Response.serialize(value, alloc, MapSerializer.INSTANCE);
    }

    public static void map(Map<?, ?> value, ByteBufPool alloc, Resp3Type contentType) {
        Resp3Response.serialize(value, alloc, MapSerializer.INSTANCE, new SerializationHint.KeyValueHint(contentType, contentType));
    }

    public static void map(Map<?, ?> value, ByteBufPool alloc, Resp3Type keyType, Resp3Type valueType) {
        Resp3Response.serialize(value, alloc, MapSerializer.INSTANCE, new SerializationHint.KeyValueHint(keyType, valueType));
    }

    public static void error(CharSequence value, ByteBufPool alloc) {
        Resp3Response.serialize(value, alloc, PrimitiveSerializer.SimpleErrorSerializer.INSTANCE);
    }

    public static void error(Throwable t, ByteBufPool alloc) {
        Resp3Response.serialize(t, alloc, ThrowableSerializer.INSTANCE);
    }

    public static <T> void write(T object, ByteBufPool alloc, JavaObjectSerializer<T> serializer) {
        Resp3Response.serialize(object, alloc, serializer);
    }

    public static <T> void write(ByteBufPool alloc, JavaObjectSerializer<T> serializer) {
        Resp3Response.serialize(alloc, alloc, serializer);
    }

    public static void serialize(Object object, ByteBufPool alloc) {
        Resp3SerializerRegistry.serialize(object, alloc);
    }

    private static void serialize(Object object, ByteBufPool alloc, ResponseSerializer<?> candidate) {
        Resp3SerializerRegistry.serialize(object, alloc, candidate);
    }

    private static <H extends SerializationHint> void serialize(Object object, ByteBufPool alloc, NestedResponseSerializer<?, H> candidate, H hint) {
        Resp3SerializerRegistry.serialize(object, alloc, candidate, hint);
    }
}

