/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.util.Collection;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.RespConstants;

public final class ByteBufferUtils {
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    private ByteBufferUtils() {
    }

    public static ByteBuf stringToResult(byte[] result, ByteBufPool alloc) {
        int exactSize = result == null ? 1 + RespConstants.CRLF.length : 1 + ByteBufferUtils.stringSize(result.length) + RespConstants.CRLF.length;
        ByteBuf buffer = alloc.acquire(exactSize);
        buffer.writeByte(43);
        if (result != null) {
            buffer.writeBytes(result);
        }
        buffer.writeBytes(RespConstants.CRLF);
        return buffer;
    }

    public static ByteBuf bytesToResult(byte[] result, ByteBufPool alloc) {
        int length = result.length;
        int stringLength = ByteBufferUtils.stringSize(length);
        int exactSize = stringLength + length + 5;
        ByteBuf buffer = alloc.acquire(exactSize);
        buffer.writeByte(36);
        ByteBufferUtils.setIntChars(length, stringLength, buffer);
        buffer.writeBytes(RespConstants.CRLF);
        buffer.writeBytes(result);
        buffer.writeBytes(RespConstants.CRLF);
        return buffer;
    }

    public static ByteBuf writeLong(Long result, ByteBufPool alloc) {
        if (result == null) {
            return alloc.acquire(RespConstants.NIL.length).writeBytes(RespConstants.NIL);
        }
        int size = 1 + ByteBufferUtils.stringSize(result) + 2;
        ByteBuf buffer = alloc.acquire(size);
        buffer.writeByte(58);
        ByteBufferUtils.setIntChars(result, size - 3, buffer);
        return buffer.writeBytes(RespConstants.CRLF);
    }

    public static ByteBuf bytesToResultWrapped(Collection<ScoredValue<byte[]>> results, ByteBufPool alloc) {
        if (results.isEmpty()) {
            return ByteBufferUtils.stringToByteBufAscii("*0\r\n", alloc);
        }
        int resultBytesSize = 0;
        for (ScoredValue<byte[]> result : results) {
            int length;
            resultBytesSize = result == null ? (resultBytesSize += 3) : ((length = ((byte[])result.getValue()).length) > 0 ? (resultBytesSize += 1 + ByteBufferUtils.stringSize(length) + 2 + length) : (resultBytesSize += 4));
            resultBytesSize += 2;
        }
        return ByteBufferUtils.bytesToResultWrapped(resultBytesSize, results, alloc);
    }

    public static ByteBuf bytesToResult(Collection<byte[]> results, ByteBufPool alloc) {
        if (results.isEmpty()) {
            return ByteBufferUtils.stringToByteBufAscii("*0\r\n", alloc);
        }
        int resultBytesSize = 0;
        for (byte[] result : results) {
            int length;
            resultBytesSize = result == null ? (resultBytesSize += 3) : ((length = result.length) > 0 ? (resultBytesSize += 1 + ByteBufferUtils.stringSize(length) + 2 + length) : (resultBytesSize += 4));
            resultBytesSize += 2;
        }
        return ByteBufferUtils.bytesToResult(resultBytesSize, results, alloc);
    }

    public static ByteBuf bytesToResult(int resultBytesSize, Collection<byte[]> results, ByteBufPool alloc) {
        int elements = results.size();
        int elementsSize = ByteBufferUtils.stringSize(elements);
        int byteAmount = 1 + elementsSize + 2 + resultBytesSize;
        ByteBuf byteBuf = (ByteBuf)alloc.apply(byteAmount);
        byteBuf.writeByte(42);
        ByteBufferUtils.setIntChars(elements, elementsSize, byteBuf);
        byteBuf.writeBytes(RespConstants.CRLF);
        for (byte[] value : results) {
            if (value == null) {
                byteBuf.writeCharSequence((CharSequence)"$-1", CharsetUtil.US_ASCII);
            } else {
                byteBuf.writeByte(36);
                ByteBufferUtils.setIntChars(value.length, ByteBufferUtils.stringSize(value.length), byteBuf);
                byteBuf.writeBytes(RespConstants.CRLF);
                byteBuf.writeBytes(value);
            }
            byteBuf.writeBytes(RespConstants.CRLF);
        }
        return byteBuf;
    }

    public static ByteBuf bytesToResultWrapped(int resultBytesSize, Collection<ScoredValue<byte[]>> results, ByteBufPool alloc) {
        int elements = results.size();
        int elementsSize = ByteBufferUtils.stringSize(elements);
        int byteAmount = 1 + elementsSize + 2 + resultBytesSize;
        ByteBuf byteBuf = (ByteBuf)alloc.apply(byteAmount);
        byteBuf.writeByte(42);
        ByteBufferUtils.setIntChars(elements, elementsSize, byteBuf);
        byteBuf.writeBytes(RespConstants.CRLF);
        for (ScoredValue<byte[]> scoredValue : results) {
            if (scoredValue == null) {
                byteBuf.writeCharSequence((CharSequence)"$-1", CharsetUtil.US_ASCII);
            } else {
                byteBuf.writeByte(36);
                ByteBufferUtils.setIntChars(((byte[])scoredValue.getValue()).length, ByteBufferUtils.stringSize(((byte[])scoredValue.getValue()).length), byteBuf);
                byteBuf.writeBytes(RespConstants.CRLF);
                byteBuf.writeBytes((byte[])scoredValue.getValue());
            }
            byteBuf.writeBytes(RespConstants.CRLF);
        }
        return byteBuf;
    }

    public static int setIntChars(long i, int index, ByteBuf buf) {
        int r;
        long q;
        boolean negative;
        int writeIndex = buf.writerIndex();
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= -100L) {
            q = i / 100L;
            r = (int)(q * 100L - i);
            i = q;
            buf.setByte(writeIndex + --charPos, (int)DigitOnes[r]);
            buf.setByte(writeIndex + --charPos, (int)DigitTens[r]);
        }
        q = i / 10L;
        r = (int)(q * 10L - i);
        buf.setByte(writeIndex + --charPos, (int)((byte)(48 + r)));
        if (q < 0L) {
            buf.setByte(writeIndex + --charPos, (int)((byte)(48L - q)));
        }
        if (negative) {
            buf.setByte(writeIndex + --charPos, 45);
        }
        buf.writerIndex(writeIndex + index);
        return charPos;
    }

    public static int stringSize(long x) {
        int d = 1;
        if (x >= 0L) {
            d = 0;
            x = -x;
        }
        int p = -10;
        for (int i = 1; i < 10; ++i) {
            if (x > (long)p) {
                return i + d;
            }
            p = 10 * p;
        }
        return 10 + d;
    }

    public static void writeInt(ByteBuf buf, long value) {
        ByteBufferUtils.setIntChars(value, ByteBufferUtils.stringSize(value), buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf stringToByteBufAscii(CharSequence string, ByteBufPool alloc) {
        boolean release = true;
        ByteBuf buffer = (ByteBuf)alloc.apply(string.length());
        try {
            ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)string);
            release = false;
        }
        finally {
            if (release) {
                buffer.release();
            }
        }
        return buffer;
    }

    public static ByteBuf stringToByteBuf(CharSequence string, ByteBufPool alloc) {
        return ByteBufferUtils.stringToByteBufWithExtra(string, alloc, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf stringToByteBufWithExtra(CharSequence string, ByteBufPool alloc, int extraBytes) {
        boolean release = true;
        int stringBytes = ByteBufUtil.utf8Bytes((CharSequence)string);
        int allocatedSize = stringBytes + extraBytes;
        ByteBuf buffer = (ByteBuf)alloc.apply(allocatedSize);
        try {
            int beforeWriteIndex = buffer.writerIndex();
            ByteBufUtil.reserveAndWriteUtf8((ByteBuf)buffer, (CharSequence)string, (int)allocatedSize);
            assert (buffer.capacity() - buffer.writerIndex() >= extraBytes);
            assert (buffer.writerIndex() - beforeWriteIndex == stringBytes);
            release = false;
        }
        finally {
            if (release) {
                buffer.release();
            }
        }
        return buffer;
    }
}

