/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.impl.EmbeddedMultimapListCache;
import org.infinispan.multimap.impl.EmbeddedMultimapPairCache;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Resp3AuthHandler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespConstants;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.commands.Resp3Command;

public class Resp3Handler
extends Resp3AuthHandler {
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();
    protected AdvancedCache<byte[], byte[]> ignorePreviousValueCache;
    protected EmbeddedMultimapListCache<byte[], byte[]> listMultimap;
    protected EmbeddedMultimapPairCache<byte[], byte[], byte[]> mapMultimap;
    protected EmbeddedSetCache<byte[], byte[]> embeddedSetCache;
    protected EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetMultimap;
    protected final ScheduledExecutorService scheduler;
    private final MediaType valueMediaType;

    Resp3Handler(RespServer respServer, MediaType valueMediaType) {
        super(respServer);
        this.valueMediaType = valueMediaType;
        this.scheduler = (ScheduledExecutorService)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cache.getCacheManager()).getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout");
    }

    @Override
    public void setCache(AdvancedCache<byte[], byte[]> cache) {
        super.setCache(cache);
        this.ignorePreviousValueCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES});
        AdvancedCache toMultimap = cache.withMediaType(MediaType.APPLICATION_OCTET_STREAM, this.valueMediaType);
        this.listMultimap = new EmbeddedMultimapListCache((Cache)toMultimap);
        this.mapMultimap = new EmbeddedMultimapPairCache((Cache)toMultimap);
        this.embeddedSetCache = new EmbeddedSetCache((Cache)toMultimap);
        this.sortedSetMultimap = new EmbeddedMultimapSortedSetCache((Cache)toMultimap);
    }

    public EmbeddedMultimapListCache<byte[], byte[]> getListMultimap() {
        return this.listMultimap;
    }

    public EmbeddedMultimapPairCache<byte[], byte[], byte[]> getHashMapMultimap() {
        return this.mapMultimap;
    }

    public EmbeddedSetCache<byte[], byte[]> getEmbeddedSetCache() {
        return this.embeddedSetCache;
    }

    public EmbeddedMultimapSortedSetCache<byte[], byte[]> getSortedSeMultimap() {
        return this.sortedSetMultimap;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand type, List<byte[]> arguments) {
        if (type instanceof Resp3Command) {
            Resp3Command resp3Command = (Resp3Command)((Object)type);
            return resp3Command.perform(this, ctx, arguments);
        }
        return super.actualHandleRequest(ctx, type, arguments);
    }

    protected static void handleLongResult(Long result, ByteBufPool alloc) {
        ByteBufferUtils.writeLong(result, alloc);
    }

    protected static void handleDoubleResult(Double result, ByteBufPool alloc) {
        if (result == null) {
            Resp3Handler.handleNullResult(alloc);
        } else {
            Resp3Handler.handleBulkAsciiResult(Double.toString(result), alloc);
        }
    }

    protected static void handleCollectionDoubleResult(Collection<Double> collection, ByteBufPool alloc) {
        if (collection == null) {
            Resp3Handler.handleNullResult(alloc);
        } else {
            Resp3Handler.writeArrayPrefix(collection.size(), alloc);
            for (Double d : collection) {
                if (d == null) {
                    Resp3Handler.handleNullResult(alloc);
                    continue;
                }
                Resp3Handler.handleDoubleResult(d, alloc);
            }
        }
    }

    protected static void handleCollectionLongResult(Collection<Long> collection, ByteBufPool alloc) {
        if (collection == null) {
            Resp3Handler.handleNullResult(alloc);
        } else {
            String result = "*" + collection.size() + "\r\n" + collection.stream().map(value -> ":" + value + "\r\n").collect(Collectors.joining());
            ByteBufferUtils.stringToByteBufAscii(result, alloc);
        }
    }

    public static void handleBulkResult(CharSequence result, ByteBufPool alloc) {
        if (result == null) {
            Resp3Handler.handleNullResult(alloc);
        } else {
            int resultLength = ByteBufUtil.utf8Bytes((CharSequence)result);
            int resultSizeLength = ByteBufferUtils.stringSize(resultLength);
            ByteBuf buf = alloc.acquire(1 + resultSizeLength + 2 + resultLength + 2);
            buf.writeByte(36);
            ByteBufferUtils.setIntChars(resultLength, resultSizeLength, buf);
            buf.writeBytes(RespConstants.CRLF);
            ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)result);
            buf.writeBytes(RespConstants.CRLF);
        }
    }

    public static void handleBulkAsciiResult(CharSequence result, ByteBufPool alloc) {
        if (result == null) {
            Resp3Handler.handleNullResult(alloc);
        } else {
            int resultLength = result.length();
            int resultSizeLength = ByteBufferUtils.stringSize(resultLength);
            ByteBuf buf = alloc.acquire(1 + resultSizeLength + 2 + resultLength + 2);
            buf.writeByte(36);
            ByteBufferUtils.setIntChars(resultLength, resultSizeLength, buf);
            buf.writeBytes(RespConstants.CRLF);
            ByteBufUtil.writeAscii((ByteBuf)buf, (CharSequence)result);
            buf.writeBytes(RespConstants.CRLF);
        }
    }

    public static void handleCollectionBulkResult(Collection<byte[]> collection, ByteBufPool alloc) {
        if (collection == null) {
            Resp3Handler.handleNullResult(alloc);
            return;
        }
        int dataLength = collection.stream().mapToInt(ba -> ((byte[])ba).length + 5 + Resp3Handler.lenghtInChars(((byte[])ba).length)).sum();
        ByteBuf buffer = Resp3Handler.allocAndWriteLengthPrefix('*', collection.size(), alloc, dataLength);
        collection.forEach(wba -> Resp3Handler.writeBulkResult(wba, buffer));
    }

    private static void handleNullResult(ByteBufPool alloc) {
        ByteBufferUtils.stringToByteBufAscii("$-1\r\n", alloc);
    }

    protected static void handleBulkResult(byte[] result, ByteBufPool alloc) {
        if (result == null) {
            Resp3Handler.handleNullResult(alloc);
            return;
        }
        ByteBuf buffer = Resp3Handler.allocAndWriteLengthPrefix('$', result.length, alloc, result.length + 2);
        buffer.writeBytes(result);
        buffer.writeBytes(CRLF_BYTES);
    }

    private static void writeBulkResult(byte[] result, ByteBuf buffer) {
        Resp3Handler.writeLengthPrefix('$', result.length, buffer);
        buffer.writeBytes(result);
        buffer.writeBytes(CRLF_BYTES);
    }

    protected static void handleThrowable(ByteBufPool alloc, Throwable t) {
        Consumer<ByteBufPool> writer = RespErrorUtil.handleException(t);
        if (writer != null) {
            writer.accept(alloc);
        } else {
            ByteBufferUtils.stringToByteBuf("-ERR " + t.getMessage() + "\r\n", alloc);
        }
    }

    public AdvancedCache<byte[], byte[]> ignorePreviousValuesCache() {
        return this.ignorePreviousValueCache;
    }

    public CompletionStage<RespRequestHandler> delegate(ChannelHandlerContext ctx, RespCommand command, List<byte[]> arguments) {
        return super.actualHandleRequest(ctx, command, arguments);
    }

    public void checkPermission(AuthorizationPermission authorizationPermission) {
        AuthorizationManager authorizationManager = this.cache.getAuthorizationManager();
        if (authorizationManager != null) {
            authorizationManager.checkPermission(authorizationPermission);
        }
    }

    public static void writeArrayPrefix(int size, ByteBufPool alloc) {
        Resp3Handler.allocAndWriteLengthPrefix('*', size, alloc, 0);
    }

    public static void writeMapPrefix(int size, ByteBufPool alloc) {
        Resp3Handler.allocAndWriteLengthPrefix('%', size, alloc, 0);
    }

    private static ByteBuf allocAndWriteLengthPrefix(char type, int size, ByteBufPool alloc, int additionalBytes) {
        int strLength = Resp3Handler.lenghtInChars(size);
        ByteBuf buffer = alloc.acquire(strLength + additionalBytes + 3);
        buffer.writeByte((int)type);
        ByteBufferUtils.setIntChars(size, strLength, buffer);
        buffer.writeBytes(CRLF_BYTES);
        return buffer;
    }

    private static int lenghtInChars(int size) {
        int strLength = size == 0 ? 1 : (int)Math.log10(size) + 1;
        return strLength;
    }

    private static ByteBuf writeLengthPrefix(char type, int size, ByteBuf buffer) {
        int strLength = Resp3Handler.lenghtInChars(size);
        buffer.writeByte((int)type);
        ByteBufferUtils.setIntChars(size, strLength, buffer);
        buffer.writeBytes(CRLF_BYTES);
        return buffer;
    }
}

