/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonArrindexFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Integer>> {
    public static final AdvancedExternalizer<JsonArrindexFunction> EXTERNALIZER = new Externalizer();
    private byte[] jsonPath;
    private byte[] value;
    private int start;
    private int stop;
    private boolean isLegacy;

    public JsonArrindexFunction(byte[] jsonPath, byte[] value, int start, int stop, boolean isLegacy) {
        this.jsonPath = jsonPath;
        this.value = value;
        this.start = start;
        this.stop = stop;
        this.isLegacy = isLegacy;
    }

    public List<Integer> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        Optional existing = entryView.peek();
        if (existing.isEmpty()) {
            throw new CacheException("Path '" + RespUtil.ascii(this.jsonPath) + "' does not exist");
        }
        byte[] doc = ((JsonBucket)existing.get()).value();
        ObjectMapper mapper = JSONUtil.objectMapper;
        try {
            JsonNode rootNode = mapper.readTree(RespUtil.utf8(doc));
            JsonNode valueNode = mapper.readTree(RespUtil.utf8(this.value));
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(RespUtil.utf8(this.jsonPath), new Predicate[0]);
            ArrayList<Integer> resultList = new ArrayList<Integer>();
            for (JsonNode jsonNode : nodeList) {
                int index = -1;
                int stop = this.toEndIndex(this.stop, jsonNode.size());
                if (jsonNode.isArray()) {
                    ArrayNode arrNode = (ArrayNode)jsonNode;
                    for (int curr = this.toStartIndex(this.start, jsonNode.size()); curr < stop; ++curr) {
                        if (!arrNode.get(curr).equals((Object)valueNode)) continue;
                        index = curr;
                        break;
                    }
                    resultList.add(index);
                    if (!this.isLegacy) continue;
                    return resultList;
                }
                if (this.isLegacy) {
                    throw new CacheException("-WRONGTYPE wrong type of path value - expected array but found " + jsonNode.getNodeType().name().toLowerCase());
                }
                resultList.add(null);
            }
            if (resultList.isEmpty() && this.isLegacy) {
                throw new CacheException("Path '" + RespUtil.ascii(this.jsonPath) + "' does not exist");
            }
            return resultList;
        }
        catch (JsonProcessingException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private int toStartIndex(int start, int size) {
        return start < 0 ? Math.max(size + start, 0) : Math.min(start, size);
    }

    private int toEndIndex(int stop, int size) {
        return stop <= 0 ? Math.max(size + stop, 0) : Math.min(stop, size);
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonArrindexFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonArrindexFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.jsonPath);
            JSONUtil.writeBytes(output, object.value);
            output.writeInt(object.start);
            output.writeInt(object.stop);
            output.writeBoolean(object.isLegacy);
        }

        public JsonArrindexFunction readObject(ObjectInput input) throws IOException {
            byte[] jsonPath = JSONUtil.readBytes(input);
            byte[] value = JSONUtil.readBytes(input);
            int start = input.readInt();
            int stop = input.readInt();
            boolean isLegacy = input.readBoolean();
            return new JsonArrindexFunction(jsonPath, value, start, stop, isLegacy);
        }

        public Set<Class<? extends JsonArrindexFunction>> getTypeClasses() {
            return Collections.singleton(JsonArrindexFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_ARRINDEX_FUNCTION;
        }
    }
}

