/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonArrpopFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<byte[]>> {
    public static final AdvancedExternalizer<JsonArrpopFunction> EXTERNALIZER = new Externalizer();
    private byte[] path;
    private int index;

    public JsonArrpopFunction(byte[] path, int index) {
        this.path = path;
        this.index = index;
    }

    public List<byte[]> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        if (doc == null) {
            return null;
        }
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtxPath = JSONUtil.parserForMod.parse((Object)rootNode);
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode pathList = (ArrayNode)jpCtxPath.read(jpath);
            ArrayList<byte[]> resList = new ArrayList<byte[]>();
            boolean changed = false;
            for (JsonNode pathAsNode : pathList) {
                ArrayNode node = (ArrayNode)jpCtx.read(pathAsNode.asText(), new Predicate[0]);
                JsonNode jsonNode = node.get(0);
                if (jsonNode.isArray() && jsonNode.size() > 0) {
                    ArrayNode destNode = (ArrayNode)jsonNode;
                    int removeIndex = this.toRemoveIndex(this.index, destNode.size());
                    JsonNode removed = destNode.remove(removeIndex);
                    if (JSONUtil.isRoot(pathAsNode.asText().getBytes(StandardCharsets.UTF_8))) {
                        entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)destNode)), new MetaParam.Writable[0]);
                        resList.add(removed.toString().getBytes(StandardCharsets.UTF_8));
                        continue;
                    }
                    jpCtx.set(pathAsNode.asText(), (Object)destNode, new Predicate[0]);
                    changed = true;
                    resList.add(removed.toString().getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                resList.add(null);
            }
            if (changed) {
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootNode)), new MetaParam.Writable[0]);
            }
            return resList;
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private int toRemoveIndex(int index, int size) {
        return index < 0 ? Math.max(0, size + index) : Math.min(size - 1, index);
    }

    public static class Externalizer
    implements AdvancedExternalizer<JsonArrpopFunction> {
        public void writeObject(ObjectOutput output, JsonArrpopFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
            output.writeInt(object.index);
        }

        public JsonArrpopFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] jsonPath = JSONUtil.readBytes(input);
            int index = input.readInt();
            return new JsonArrpopFunction(jsonPath, index);
        }

        public Set<Class<? extends JsonArrpopFunction>> getTypeClasses() {
            return Collections.singleton(JsonArrpopFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_ARRPOP_FUNCTION;
        }
    }
}

