/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.bytebuf;

import io.netty.buffer.ByteBuf;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.RespConstants;

public final class ByteBufferUtils {
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    private ByteBufferUtils() {
    }

    public static int setIntChars(long i, int index, ByteBuf buf) {
        int r;
        long q;
        boolean negative;
        int writeIndex = buf.writerIndex();
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= -100L) {
            q = i / 100L;
            r = (int)(q * 100L - i);
            i = q;
            buf.setByte(writeIndex + --charPos, (int)DigitOnes[r]);
            buf.setByte(writeIndex + --charPos, (int)DigitTens[r]);
        }
        q = i / 10L;
        r = (int)(q * 10L - i);
        buf.setByte(writeIndex + --charPos, (int)((byte)(48 + r)));
        if (q < 0L) {
            buf.setByte(writeIndex + --charPos, (int)((byte)(48L - q)));
        }
        if (negative) {
            buf.setByte(writeIndex + --charPos, 45);
        }
        buf.writerIndex(writeIndex + index);
        return charPos;
    }

    public static int stringSize(long x) {
        int d = 1;
        if (x >= 0L) {
            d = 0;
            x = -x;
        }
        long p = -10L;
        for (int i = 1; i <= 18; ++i) {
            if (x > p) {
                return i + d;
            }
            p = 10L * p;
        }
        return 19 + d;
    }

    public static void writeNumericPrefix(byte symbol, long number, ByteBufPool alloc) {
        ByteBufferUtils.writeNumericPrefix(symbol, number, alloc, 0);
    }

    public static ByteBuf writeNumericPrefix(byte symbol, long number, ByteBufPool alloc, int additionalWidth) {
        int decimalWidth = ByteBufferUtils.stringSize(number);
        int size = 1 + decimalWidth + 2 + additionalWidth;
        ByteBuf buffer = alloc.acquire(size);
        buffer.writeByte((int)symbol);
        ByteBufferUtils.setIntChars(number, decimalWidth, buffer);
        buffer.writeBytes(RespConstants.CRLF);
        return buffer;
    }
}

