/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.list.internal;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.multimap.impl.EmbeddedMultimapListCache;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseWriter;

public abstract class POP
extends RespCommand
implements Resp3Command {
    private static final BiConsumer<Object, ResponseWriter> SERIALIZER = (res, writer) -> {
        if (res instanceof Collection) {
            Collection strings = (Collection)res;
            writer.array(strings, Resp3Type.BULK_STRING);
            return;
        }
        writer.string((byte[])res);
    };
    protected boolean first;

    public POP(boolean first) {
        super(-2, 1, 1, 1);
        this.first = first;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        return this.popAndReturn(handler, ctx, arguments);
    }

    private CompletionStage<RespRequestHandler> popAndReturn(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        long count;
        byte[] key = arguments.get(0);
        switch (arguments.size()) {
            case 1: {
                count = 1L;
                break;
            }
            case 2: {
                count = ArgumentUtils.toLong(arguments.get(1));
                if (count >= 0L) break;
                handler.writer().mustBePositive();
                return handler.myStage();
            }
            default: {
                handler.writer().wrongArgumentNumber(this);
                return handler.myStage();
            }
        }
        EmbeddedMultimapListCache<byte[], byte[]> listMultimap = handler.getListMultimap();
        CompletionStage pollValues = this.first ? listMultimap.pollFirst((Object)key, count) : listMultimap.pollLast((Object)key, count);
        CompletionStage<Object> cs = pollValues.thenApply(c -> {
            if (c == null) {
                return null;
            }
            if (c.size() == 1 && arguments.size() == 1) {
                return c.iterator().next();
            }
            return c;
        });
        return handler.stageToReturn(cs, ctx, SERIALIZER);
    }
}

