/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.commands.connection.MemoryEntrySizeUtils;
import org.infinispan.server.resp.json.JSONUtil;

public record JsonBucket(byte[] value) {
    public static final AdvancedExternalizer<JsonBucket> EXTERNALIZER = new Externalizer();

    public static long memoryHeaderSize() {
        return MemoryHeader.headerSize;
    }

    private static class MemoryHeader {
        byte[] value;
        static long headerSize = MemoryEntrySizeUtils.calculateSize(new MemoryHeader());

        private MemoryHeader() {
        }
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonBucket> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonBucket object) throws IOException {
            JSONUtil.writeBytes(output, object.value);
        }

        public JsonBucket readObject(ObjectInput input) throws IOException {
            return new JsonBucket(JSONUtil.readBytes(input));
        }

        public Set<Class<? extends JsonBucket>> getTypeClasses() {
            return Collections.singleton(JsonBucket.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_BUCKET;
        }
    }
}

