/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.group.ChannelMatcher;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.RESPHashFunctionPartitioner;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.iteration.DefaultIterationManager;
import org.infinispan.server.core.iteration.ExternalSourceIterationManager;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespChannelInitializer;
import org.infinispan.server.resp.RespDecoder;
import org.infinispan.server.resp.RespDetector;
import org.infinispan.server.resp.commands.cluster.SegmentSlotRelation;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.filter.ComposedFilterConverterFactory;
import org.infinispan.server.resp.filter.GlobMatchFilterConverterFactory;
import org.infinispan.server.resp.filter.RespTypeFilterConverterFactory;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.server.resp.meta.MetadataRepository;
import org.infinispan.server.resp.scripting.LuaTaskEngine;
import org.infinispan.tasks.manager.TaskManager;
import org.infinispan.tasks.manager.spi.TaskEngine;
import org.infinispan.transaction.LockingMode;

public class RespServer
extends AbstractProtocolServer<RespServerConfiguration> {
    private static final org.infinispan.commons.logging.Log log = LogFactory.getLog(RespServer.class);
    public static final String RESP_SERVER_FEATURE = "resp-server";
    public static final MediaType RESP_KEY_MEDIA_TYPE = MediaType.APPLICATION_OCTET_STREAM;
    private MetadataRepository metadataRepository;
    private MediaType configuredValueType = MediaType.APPLICATION_OCTET_STREAM;
    private DefaultIterationManager iterationManager;
    private ExternalSourceIterationManager dataStructureIterationManager;
    private TimeService timeService;
    private SegmentSlotRelation segmentSlots;
    private LuaTaskEngine luaTaskEngine;
    private final Random random = new Random();

    public RespServer() {
        super("Resp");
    }

    protected void internalPostStart() {
        GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cacheManager);
        this.timeService = gcr.getTimeService();
        this.iterationManager = new DefaultIterationManager(gcr.getTimeService());
        this.dataStructureIterationManager = new ExternalSourceIterationManager(gcr.getTimeService());
        this.iterationManager.addKeyValueFilterConverterFactory(GlobMatchFilterConverterFactory.class.getName(), (KeyValueFilterConverterFactory)new GlobMatchFilterConverterFactory());
        this.iterationManager.addKeyValueFilterConverterFactory(RespTypeFilterConverterFactory.class.getName(), (KeyValueFilterConverterFactory)new RespTypeFilterConverterFactory());
        this.iterationManager.addKeyValueFilterConverterFactory(ComposedFilterConverterFactory.class.getName(), (KeyValueFilterConverterFactory)new ComposedFilterConverterFactory());
        this.dataStructureIterationManager.addKeyValueFilterConverterFactory(GlobMatchFilterConverterFactory.class.getName(), (KeyValueFilterConverterFactory)new GlobMatchFilterConverterFactory(true));
        this.metadataRepository = new MetadataRepository();
        this.initializeLuaTaskEngine(gcr);
        super.internalPostStart();
    }

    public CompletionStage<Void> initializeDefaultCache() {
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)this.cacheManager);
        if (!globalConfiguration.features().isAvailable(RESP_SERVER_FEATURE)) {
            return CompletableFuture.failedFuture((Throwable)org.infinispan.commons.logging.Log.CONFIG.featureDisabled(RESP_SERVER_FEATURE));
        }
        String cacheName = ((RespServerConfiguration)this.configuration).defaultCacheName();
        Configuration explicitConfiguration = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)this.cacheManager, (String)cacheName);
        if (explicitConfiguration == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            Configuration defaultCacheConfiguration = SecurityActions.getDefaultCacheConfiguration((EmbeddedCacheManager)this.cacheManager);
            if (defaultCacheConfiguration != null) {
                builder.read(defaultCacheConfiguration);
                this.configuredValueType = builder.encoding().value().mediaType();
                if (globalConfiguration.isClustered() && !(builder.clustering().hash().keyPartitioner() instanceof RESPHashFunctionPartitioner)) {
                    return CompletableFuture.failedFuture(org.infinispan.commons.logging.Log.CONFIG.respCacheUseDefineConsistentHash(cacheName, builder.clustering().hash().keyPartitioner().getClass().getName()));
                }
                MediaType keyMediaType = builder.encoding().key().mediaType();
                if (keyMediaType == null) {
                    log.debugf("Setting RESP cache key media type storage to OCTET stream to avoid key encodings", new Object[0]);
                    builder.encoding().key().mediaType(RESP_KEY_MEDIA_TYPE);
                } else if (!keyMediaType.equals((Object)RESP_KEY_MEDIA_TYPE)) {
                    return CompletableFuture.failedFuture(org.infinispan.commons.logging.Log.CONFIG.respCacheKeyMediaTypeSupplied(cacheName, keyMediaType));
                }
                if (builder.transaction().transactionMode().isTransactional() && builder.transaction().lockingMode() != LockingMode.PESSIMISTIC) {
                    Log.CONFIG.utilizePessimisticLocking(builder.transaction().lockingMode().name());
                }
            } else {
                if (globalConfiguration.isClustered()) {
                    builder.clustering().cacheMode(CacheMode.DIST_SYNC);
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)new RESPHashFunctionPartitioner());
                }
                builder.encoding().key().mediaType(RESP_KEY_MEDIA_TYPE);
                builder.encoding().value().mediaType(this.configuredValueType);
            }
            builder.statistics().enable().aliases(new String[]{"0"});
            explicitConfiguration = builder.build();
        } else {
            if (!RESP_KEY_MEDIA_TYPE.equals((Object)explicitConfiguration.encoding().keyDataType().mediaType())) {
                return CompletableFuture.failedFuture(org.infinispan.commons.logging.Log.CONFIG.respCacheKeyMediaTypeSupplied(cacheName, explicitConfiguration.encoding().keyDataType().mediaType()));
            }
            if (globalConfiguration.isClustered() && !(explicitConfiguration.clustering().hash().keyPartitioner() instanceof RESPHashFunctionPartitioner)) {
                return CompletableFuture.failedFuture(org.infinispan.commons.logging.Log.CONFIG.respCacheUseDefineConsistentHash(cacheName, explicitConfiguration.clustering().hash().keyPartitioner().getClass().getName()));
            }
        }
        this.segmentSlots = new SegmentSlotRelation(explicitConfiguration.clustering().hash().numSegments());
        Configuration c = explicitConfiguration;
        return this.getBlockingManager().runBlocking(() -> SecurityActions.getOrCreateCache((EmbeddedCacheManager)this.cacheManager, (String)cacheName, (Configuration)c), (Object)"create-resp-cache");
    }

    protected void startCaches() {
    }

    private void initializeLuaTaskEngine(GlobalComponentRegistry gcr) {
        ScriptingManager scriptingManager = (ScriptingManager)gcr.getComponent(ScriptingManager.class);
        this.luaTaskEngine = new LuaTaskEngine(scriptingManager);
        TaskManager taskManager = (TaskManager)gcr.getComponent(TaskManager.class);
        taskManager.registerTaskEngine((TaskEngine)this.luaTaskEngine);
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, null, null), new RespChannelInitializer(this)});
    }

    public ChannelMatcher getChannelMatcher() {
        return channel -> channel.pipeline().get(RespDecoder.class) != null;
    }

    public LuaTaskEngine luaEngine() {
        return this.luaTaskEngine;
    }

    public void stop() {
        super.stop();
        if (this.luaTaskEngine != null) {
            this.luaTaskEngine.shutdown();
        }
    }

    public AdvancedCache<byte[], byte[]> getCache() {
        if (!this.isDefaultCacheRunning()) {
            throw new IllegalStateException("Cache is not initialized");
        }
        return this.cacheManager.getCache(((RespServerConfiguration)this.configuration).defaultCacheName()).getAdvancedCache();
    }

    public Resp3Handler newHandler(AdvancedCache<byte[], byte[]> cache) {
        return new Resp3Handler(this, this.configuredValueType, cache);
    }

    public void installDetector(Channel ch) {
        ch.pipeline().addLast("resp-detector", (ChannelHandler)new RespDetector(this));
    }

    public DefaultIterationManager getIterationManager() {
        return this.iterationManager;
    }

    public ExternalSourceIterationManager getDataStructureIterationManager() {
        return this.dataStructureIterationManager;
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public SegmentSlotRelation segmentSlotRelation() {
        if (this.segmentSlots == null) {
            String cacheName = ((RespServerConfiguration)this.configuration).defaultCacheName();
            Configuration explicitConfiguration = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)this.cacheManager, (String)cacheName);
            this.segmentSlots = new SegmentSlotRelation(explicitConfiguration.clustering().hash().numSegments());
        }
        return this.segmentSlots;
    }

    public MetadataRepository metadataRepository() {
        return this.metadataRepository;
    }

    public Random random() {
        return this.random;
    }

    protected String protocolType() {
        return "redis";
    }

    public String toString() {
        return this.toString("RESP", "auth=RESP");
    }
}

