/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.set;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.set.SINTER;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class SINTERCARD
extends RespCommand
implements Resp3Command {
    static String LIMIT_OPT = "LIMIT";

    public SINTERCARD() {
        super(-3, 0, 0, 0, AclCategory.READ.mask() | AclCategory.SET.mask() | AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedSetCache<byte[], byte[]> esc = handler.getEmbeddedSetCache();
        int keysNum = 0;
        try {
            keysNum = ArgumentUtils.toInt(arguments.get(0));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (keysNum == 0) {
            handler.writer().customError("numkeys should be greater than 0");
            return handler.myStage();
        }
        int limit = this.processArgs(keysNum, arguments, handler);
        if (limit < 0) {
            return handler.myStage();
        }
        List<byte[]> keys = arguments.subList(1, keysNum + 1);
        Set<byte[]> uniqueKeys = SINTER.getUniqueKeys(handler, keys);
        CompletableFuture allEntries = esc.getAll(uniqueKeys);
        return handler.stageToReturn(allEntries.thenApply(sets -> sets.size() == uniqueKeys.size() ? (long)SINTER.intersect(sets.values(), limit).size() : (long)SINTER.checkTypesAndReturnEmpty(sets.values()).size()), ctx, ResponseWriter.INTEGER);
    }

    private int processArgs(int keysNum, List<byte[]> arguments, Resp3Handler handler) {
        if (arguments.size() < keysNum + 1) {
            handler.writer().customError("Number of keys can't be greater than number of args");
            return -1;
        }
        int optVal = 0;
        if (arguments.size() > keysNum + 1) {
            if (arguments.size() != keysNum + 3) {
                handler.writer().syntaxError();
                return -1;
            }
            String opt = new String(arguments.get(keysNum + 1)).toUpperCase();
            if (!LIMIT_OPT.equals(opt)) {
                handler.writer().syntaxError();
                return -1;
            }
            try {
                optVal = ArgumentUtils.toInt(arguments.get(keysNum + 2));
                if (optVal < 0) {
                    handler.writer().customError("LIMIT can't be negative");
                    return -1;
                }
            }
            catch (NumberFormatException ex) {
                handler.writer().customError("LIMIT can't be negative");
                return -1;
            }
        }
        return optVal;
    }
}

