/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6113)
public class JsonArrindexFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Integer>> {
    @ProtoField(value=1)
    final byte[] jsonPath;
    @ProtoField(value=2)
    final byte[] value;
    @ProtoField(value=3)
    final int start;
    @ProtoField(value=4)
    final int stop;
    @ProtoField(value=5)
    final boolean isLegacy;

    @ProtoFactory
    public JsonArrindexFunction(byte[] jsonPath, byte[] value, int start, int stop, boolean isLegacy) {
        this.jsonPath = jsonPath;
        this.value = value;
        this.start = start;
        this.stop = stop;
        this.isLegacy = isLegacy;
    }

    public List<Integer> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        Optional existing = entryView.peek();
        if (existing.isEmpty()) {
            throw new CacheException("Path '" + RespUtil.ascii(this.jsonPath) + "' does not exist");
        }
        byte[] doc = ((JsonBucket)existing.get()).value();
        ObjectMapper mapper = JSONUtil.objectMapper;
        try {
            JsonNode rootNode = mapper.readTree(RespUtil.utf8(doc));
            JsonNode valueNode = mapper.readTree(RespUtil.utf8(this.value));
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(RespUtil.utf8(this.jsonPath), new Predicate[0]);
            ArrayList<Integer> resultList = new ArrayList<Integer>();
            for (JsonNode jsonNode : nodeList) {
                int index = -1;
                int stop = this.toEndIndex(this.stop, jsonNode.size());
                if (jsonNode.isArray()) {
                    ArrayNode arrNode = (ArrayNode)jsonNode;
                    for (int curr = this.toStartIndex(this.start, jsonNode.size()); curr < stop; ++curr) {
                        if (!arrNode.get(curr).equals((Object)valueNode)) continue;
                        index = curr;
                        break;
                    }
                    resultList.add(index);
                    if (!this.isLegacy) continue;
                    return resultList;
                }
                if (this.isLegacy) {
                    throw new CacheException("-WRONGTYPE wrong type of path value - expected array but found " + jsonNode.getNodeType().name().toLowerCase());
                }
                resultList.add(null);
            }
            if (resultList.isEmpty() && this.isLegacy) {
                throw new CacheException("Path '" + RespUtil.ascii(this.jsonPath) + "' does not exist");
            }
            return resultList;
        }
        catch (JsonProcessingException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private int toStartIndex(int start, int size) {
        return start < 0 ? Math.max(size + start, 0) : Math.min(start, size);
    }

    private int toEndIndex(int stop, int size) {
        return stop <= 0 ? Math.max(size + stop, 0) : Math.min(stop, size);
    }
}

