/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.filters.SizeOfFilter;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6132)
public class JsonDebugMemoryFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Long>> {
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    private static SizeOf sizeof = SizeOf.newInstance((SizeOfFilter[])new SizeOfFilter[0]);
    @ProtoField(value=1)
    byte[] path;

    @ProtoFactory
    public JsonDebugMemoryFunction(byte[] path) {
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        this.path = path;
    }

    public List<Long> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            return List.of(Long.valueOf(0L));
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            if (JSONUtil.isRoot(this.path)) {
                return List.of(Long.valueOf(sizeof.deepSizeOf(new Object[]{doc.value()})));
            }
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(jpath);
            ArrayList<Long> resList = new ArrayList<Long>(nodeList.size());
            for (JsonNode jsonNode : nodeList) {
                resList.add(Long.valueOf(jsonNode.toString().getBytes(StandardCharsets.UTF_8).length));
            }
            return resList;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

