/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Objects;
import javax.security.auth.Subject;
import org.infinispan.rest.BaseHttpRequestHandler;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AuthenticationHandler
extends BaseHttpRequestHandler {
    static final Log logger = (Log)LogFactory.getLog(AuthenticationHandler.class, Log.class);
    private final Authenticator authenticator;
    private Subject subject;
    private String authorization;

    public AuthenticationHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (this.subject != null) {
            String authz = request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
            if (Objects.equals(authz, this.authorization)) {
                ctx.fireChannelRead((Object)request);
                return;
            }
            this.subject = null;
            this.authorization = null;
        }
        this.restAccessLoggingHandler.preLog(request);
        NettyRestRequest nettyRequest = new NettyRestRequest(request);
        this.authenticator.challenge(nettyRequest, ctx).whenComplete((authResponse, authThrowable) -> {
            boolean authorized;
            boolean hasError = authThrowable != null;
            boolean bl = authorized = authResponse.getStatus() != HttpResponseStatus.UNAUTHORIZED.code();
            if (!hasError && authorized) {
                this.subject = nettyRequest.getSubject();
                this.authorization = nettyRequest.getAuthorizationHeader();
                ctx.fireChannelRead((Object)request);
            } else {
                try {
                    if (hasError) {
                        this.handleError(ctx, request, (Throwable)authThrowable);
                    } else {
                        this.sendResponse(ctx, request, ((NettyRestResponse)authResponse).getResponse());
                    }
                }
                finally {
                    request.release();
                }
            }
        });
    }

    public Subject getSubject() {
        return this.subject;
    }

    @Override
    protected Log getLogger() {
        return logger;
    }
}

