/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.infinispan.rest.AuthenticationHandler;
import org.infinispan.rest.BaseHttpRequestHandler;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class Http20RequestHandler
extends BaseHttpRequestHandler {
    protected static final Log logger = (Log)LogFactory.getLog(Http20RequestHandler.class, Log.class);
    protected final RestServer restServer;
    protected final RestServerConfiguration configuration;
    private AuthenticationHandler authenticationHandler;

    public Http20RequestHandler(RestServer restServer) {
        this.restServer = restServer;
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.authenticationHandler = (AuthenticationHandler)ctx.pipeline().get(AuthenticationHandler.class);
        super.channelRegistered(ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        this.restAccessLoggingHandler.preLog(request);
        NettyRestRequest restRequest = new NettyRestRequest(request);
        if (this.authenticationHandler != null) {
            restRequest.setSubject(this.authenticationHandler.getSubject());
        }
        this.restServer.getRestDispatcher().dispatch(restRequest).whenComplete((restResponse, throwable) -> {
            try {
                if (throwable == null) {
                    NettyRestResponse nettyRestResponse = (NettyRestResponse)restResponse;
                    this.addCorrelatedHeaders(request, nettyRestResponse.getResponse());
                    this.sendResponse(ctx, request, nettyRestResponse.getResponse());
                } else {
                    this.handleError(ctx, request, (Throwable)throwable);
                }
            }
            finally {
                request.release();
            }
        });
    }

    private void addCorrelatedHeaders(FullHttpRequest request, FullHttpResponse response) {
        String streamId = request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId != null) {
            response.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpVersion httpVersion = response.protocolVersion();
        if ((httpVersion == HttpVersion.HTTP_1_1 || httpVersion == HttpVersion.HTTP_1_0) && isKeepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (e instanceof Errors.NativeIoException) {
            logger.debug("Native IO Exception", e);
            ctx.close();
        } else {
            logger.uncaughtExceptionInThePipeline(e);
            ctx.close();
        }
    }
}

