/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.RestResponseBuilder;

public class NettyRestResponse
implements RestResponse {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final String TIME_TO_LIVE_HEADER = "timeToLiveSeconds";
    private static final String MAX_IDLE_TIME_HEADER = "maxIdleTimeSeconds";
    private static final String CREATED_HEADER = "created";
    private static final String LAST_USED_HEADER = "lastUsed";
    private static final String CLUSTER_PRIMARY_OWNER_HEADER = "Cluster-Primary-Owner";
    private static final String CLUSTER_NODE_NAME_HEADER = "Cluster-Node-Name";
    private static final String CLUSTER_SERVER_ADDRESS_HEADER = "Cluster-Server-Address";
    private final FullHttpResponse response;

    private NettyRestResponse(Builder builder) {
        this.response = builder.getResponse();
    }

    public FullHttpResponse getResponse() {
        return this.response;
    }

    @Override
    public int getStatus() {
        return this.response.status().code();
    }

    @Override
    public Object getEntity() {
        return this.response.content();
    }

    public static class Builder
    implements RestResponseBuilder<Builder> {
        private DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.buffer());
        private Object entity;

        @Override
        public NettyRestResponse build() {
            ByteBuf responseContent = this.response.content();
            if (this.entity instanceof String) {
                ByteBufUtil.writeUtf8((ByteBuf)responseContent, (CharSequence)this.entity.toString());
            } else if (this.entity instanceof byte[]) {
                responseContent.writeBytes((byte[])this.entity);
            }
            HttpUtil.setContentLength((HttpMessage)this.response, (long)this.response.content().readableBytes());
            return new NettyRestResponse(this);
        }

        @Override
        public Builder header(String name, Object value) {
            if (this.response.headers().contains(name)) {
                List old = this.response.headers().getAll(name);
                ArrayList<String> all = new ArrayList<String>(old.size() + 1);
                all.addAll(old);
                all.add(value.toString());
                this.response.headers().set(name, all);
            } else {
                this.response.headers().add(name, value);
            }
            return this;
        }

        public Builder httpVersion(HttpVersion httpVersion) {
            this.response.setProtocolVersion(httpVersion);
            return this;
        }

        public Builder status(HttpResponseStatus httpStatus) {
            this.response.setStatus(httpStatus);
            return this;
        }

        @Override
        public Builder status(int status) {
            this.response.setStatus(HttpResponseStatus.valueOf((int)status));
            return this;
        }

        @Override
        public Builder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder eTag(String tag) {
            this.response.headers().set((CharSequence)HttpHeaderNames.ETAG, (Object)tag);
            return this;
        }

        @Override
        public int getStatus() {
            return this.response.status().code();
        }

        @Override
        public Object getEntity() {
            return this.response.content();
        }

        @Override
        public Builder contentType(MediaType mediaType) {
            this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType.toString());
            return this;
        }

        @Override
        public Builder expires(Date expires) {
            this.setDateHeader(HttpHeaderNames.EXPIRES, expires);
            return this;
        }

        public Builder authenticate(String authentication) {
            if (authentication != null) {
                this.response.headers().set((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)authentication);
            }
            return this;
        }

        @Override
        public Builder lastModified(Date lastModified) {
            this.setDateHeader(HttpHeaderNames.LAST_MODIFIED, lastModified);
            return this;
        }

        @Override
        public Builder cacheControl(CacheControl cacheControl) {
            if (cacheControl != null) {
                this.response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)cacheControl);
            }
            return this;
        }

        @Override
        public Object getHeader(String header) {
            return this.response.headers().get(header);
        }

        public Builder timeToLive(long timeToLive) {
            if (timeToLive > -1L) {
                this.response.headers().set(NettyRestResponse.TIME_TO_LIVE_HEADER, (Object)TimeUnit.MILLISECONDS.toSeconds(timeToLive));
            }
            return this;
        }

        public Builder maxIdle(long maxIdle) {
            if (maxIdle > -1L) {
                this.response.headers().set(NettyRestResponse.MAX_IDLE_TIME_HEADER, (Object)TimeUnit.MILLISECONDS.toSeconds(maxIdle));
            }
            return this;
        }

        public Builder created(long created) {
            if (created > -1L) {
                this.response.headers().set(NettyRestResponse.CREATED_HEADER, (Object)created);
            }
            return this;
        }

        public Builder lastUsed(long lastUsed) {
            if (lastUsed > -1L) {
                this.response.headers().set(NettyRestResponse.LAST_USED_HEADER, (Object)lastUsed);
            }
            return this;
        }

        public Builder clusterPrimaryOwner(String primaryOwner) {
            this.response.headers().set(NettyRestResponse.CLUSTER_PRIMARY_OWNER_HEADER, (Object)primaryOwner);
            return this;
        }

        public Builder clusterNodeName(String nodeName) {
            this.response.headers().set(NettyRestResponse.CLUSTER_NODE_NAME_HEADER, (Object)nodeName);
            return this;
        }

        public Builder clusterServerAddress(String serverAddress) {
            this.response.headers().set(NettyRestResponse.CLUSTER_SERVER_ADDRESS_HEADER, (Object)serverAddress);
            return this;
        }

        public HttpVersion getHttpVersion() {
            return this.response.protocolVersion();
        }

        public HttpResponseStatus getHttpStatus() {
            return this.response.status();
        }

        public DefaultFullHttpResponse getResponse() {
            return this.response;
        }

        private void setDateHeader(AsciiString headerName, Date value) {
            if (value != null) {
                this.response.headers().set((CharSequence)headerName, (Object)DATE_TIME_FORMATTER.format(value.toInstant()));
            }
        }
    }
}

