/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.RestChannelInitializer;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.AuthenticationConfiguration;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestDispatcher;
import org.infinispan.rest.framework.impl.ResourceManagerImpl;
import org.infinispan.rest.framework.impl.RestDispatcherImpl;
import org.infinispan.rest.resources.CacheManagerResource;
import org.infinispan.rest.resources.CacheResource;
import org.infinispan.rest.resources.CacheResourceV2;
import org.infinispan.rest.resources.CounterResource;
import org.infinispan.rest.resources.SplashResource;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;

public class RestServer
extends AbstractProtocolServer<RestServerConfiguration> {
    private RestDispatcher restDispatcher;
    private RestCacheManager<Object> restCacheManager;
    private final ObjectMapper mapper = new ObjectMapper();

    public RestServer() {
        super("REST");
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{this.getRestChannelInitializer()});
    }

    public RestChannelInitializer getRestChannelInitializer() {
        return new RestChannelInitializer(this, this.transport);
    }

    RestDispatcher getRestDispatcher() {
        return this.restDispatcher;
    }

    public void stop() {
        super.stop();
        this.restCacheManager.stop();
    }

    protected void startInternal(RestServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        this.configuration = configuration;
        AuthenticationConfiguration auth = configuration.authentication();
        if (auth.enabled()) {
            auth.authenticator().init(this);
        }
        super.startInternal((ProtocolServerConfiguration)configuration, cacheManager);
        this.restCacheManager = new RestCacheManager(cacheManager, arg_0 -> ((RestServer)this).isCacheIgnored(arg_0));
        InvocationHelper invocationHelper = new InvocationHelper(this.restCacheManager, (EmbeddedCounterManager)EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager), configuration, this.getExecutor());
        String rootContext = configuration.startTransport() ? configuration.contextPath() : "*";
        ResourceManagerImpl resourceManager = new ResourceManagerImpl(rootContext);
        resourceManager.registerResource(new CacheResource(invocationHelper));
        resourceManager.registerResource(new CacheResourceV2(invocationHelper));
        resourceManager.registerResource(new SplashResource());
        resourceManager.registerResource(new CounterResource(invocationHelper));
        resourceManager.registerResource(new CacheManagerResource(invocationHelper));
        this.restDispatcher = new RestDispatcherImpl(resourceManager);
    }
}

