/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.infinispan.security.Security;
import org.infinispan.security.actions.AddCacheManagerListenerAction;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheConfigurationAction;
import org.infinispan.security.actions.GetCacheDistributionManagerAction;
import org.infinispan.security.actions.GetCacheEntryAsyncAction;
import org.infinispan.security.actions.RemoveListenerAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static void addListener(EmbeddedCacheManager cacheManager, Object listener) {
        SecurityActions.doPrivileged(new AddCacheManagerListenerAction(cacheManager, listener));
    }

    static Void removeListener(Listenable listenable, Object listener) {
        RemoveListenerAction action = new RemoveListenerAction(listenable, listener);
        return (Void)SecurityActions.doPrivileged(action);
    }

    static DistributionManager getDistributionManager(Cache<?, ?> cache) {
        GetCacheDistributionManagerAction action = new GetCacheDistributionManagerAction(cache.getAdvancedCache());
        return (DistributionManager)SecurityActions.doPrivileged(action);
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return (ComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static <K, V> CompletionStage<CacheEntry<K, V>> getCacheEntryAsync(AdvancedCache<K, V> cache, K key) {
        GetCacheEntryAsyncAction action = new GetCacheEntryAsyncAction(cache, key);
        return (CompletionStage)SecurityActions.doPrivileged(action);
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        GetCacheConfigurationAction action = new GetCacheConfigurationAction(cache);
        return (Configuration)SecurityActions.doPrivileged(action);
    }
}

