/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.authentication.Authenticator;

public class AuthenticationConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<Authenticator> AUTHENTICATOR = AttributeDefinition.builder((String)"authenticator", null, Authenticator.class).immutable().build();
    public static final AttributeDefinition<List<String>> MECHANISMS = AttributeDefinition.builder((String)"mechanisms", null, List.class).initializer(ArrayList::new).immutable().build();
    private final Attribute<Boolean> enabled;
    private final Attribute<Authenticator> authenticator;
    private final Attribute<List<String>> mechanisms;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthenticationConfiguration.class, new AttributeDefinition[]{ENABLED, AUTHENTICATOR, MECHANISMS});
    }

    AuthenticationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.authenticator = attributes.attribute(AUTHENTICATOR);
        this.mechanisms = attributes.attribute(MECHANISMS);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public List<String> mechanisms() {
        return (List)this.mechanisms.get();
    }

    public Authenticator authenticator() {
        return (Authenticator)this.authenticator.get();
    }

    public String toString() {
        return "AuthenticationConfiguration[enabled=" + this.enabled + ", mechanisms=" + this.mechanisms + ", authenticator=" + this.authenticator + ']';
    }
}

