/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.AuthenticationConfiguration;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.AbstractProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;

public class AuthenticationConfigurationBuilder
extends AbstractProtocolServerConfigurationChildBuilder<RestServerConfiguration, AuthenticationConfigurationBuilder>
implements Builder<AuthenticationConfiguration> {
    private final AttributeSet attributes = AuthenticationConfiguration.attributeDefinitionSet();

    AuthenticationConfigurationBuilder(ProtocolServerConfigurationBuilder builder) {
        super((ProtocolServerConfigurationChildBuilder)builder);
    }

    public AuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public AuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(AuthenticationConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public AuthenticationConfigurationBuilder authenticator(Authenticator authenticator) {
        this.attributes.attribute(AuthenticationConfiguration.AUTHENTICATOR).set((Object)authenticator);
        return this.enable();
    }

    public AuthenticationConfigurationBuilder addMechanisms(String ... mechanisms) {
        List mechs = (List)this.attributes.attribute(AuthenticationConfiguration.MECHANISMS).get();
        for (int i = 0; i < mechanisms.length; ++i) {
            mechs.add(mechanisms[i]);
        }
        this.attributes.attribute(AuthenticationConfiguration.MECHANISMS).set((Object)mechs);
        return this.enable();
    }

    public void validate() {
        if (((Boolean)this.attributes.attribute(AuthenticationConfiguration.ENABLED).get()).booleanValue() && this.attributes.attribute(AuthenticationConfiguration.AUTHENTICATOR).isNull()) {
            throw RestServerConfigurationBuilder.logger.authenticationWithoutAuthenticator();
        }
    }

    public AuthenticationConfiguration create() {
        return new AuthenticationConfiguration(this.attributes.protect());
    }

    public Builder<?> read(AuthenticationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public AuthenticationConfigurationBuilder self() {
        return this;
    }
}

