/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.cors.CorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.AuthenticationConfiguration;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;

@BuiltBy(value=RestServerConfigurationBuilder.class)
@ConfigurationFor(value=RestServer.class)
public class RestServerConfiguration
extends ProtocolServerConfiguration {
    public static final AttributeDefinition<ExtendedHeaders> EXTENDED_HEADERS = AttributeDefinition.builder((String)"extended-header", (Object)((Object)ExtendedHeaders.ON_DEMAND)).immutable().build();
    public static final AttributeDefinition<String> CONTEXT_PATH = AttributeDefinition.builder((String)"context-path", (Object)"rest").immutable().build();
    public static final AttributeDefinition<Integer> MAX_CONTENT_LENGTH = AttributeDefinition.builder((String)"max-content-length", (Object)0xA00000).immutable().build();
    public static final AttributeDefinition<List<CorsConfig>> CORS_RULES = AttributeDefinition.builder((String)"cors-rules", null, List.class).initializer(() -> new ArrayList(3)).immutable().build();
    public static final AttributeDefinition<Integer> COMPRESSION_LEVEL = AttributeDefinition.builder((String)"compression-level", (Object)6).immutable().build();
    private final Attribute<ExtendedHeaders> extendedHeaders;
    private final Attribute<String> contextPath;
    private final Attribute<Integer> maxContentLength;
    private final Attribute<List<CorsConfig>> corsRules;
    private final Attribute<Integer> compressionLevel;
    private final AuthenticationConfiguration authentication;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RestServerConfiguration.class, ProtocolServerConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{WORKER_THREADS, EXTENDED_HEADERS, CONTEXT_PATH, MAX_CONTENT_LENGTH, CORS_RULES, COMPRESSION_LEVEL});
    }

    RestServerConfiguration(AttributeSet attributes, SslConfiguration ssl, AuthenticationConfiguration authentication) {
        super(attributes, ssl);
        this.authentication = authentication;
        this.extendedHeaders = attributes.attribute(EXTENDED_HEADERS);
        this.contextPath = attributes.attribute(CONTEXT_PATH);
        this.maxContentLength = attributes.attribute(MAX_CONTENT_LENGTH);
        this.corsRules = attributes.attribute(CORS_RULES);
        this.compressionLevel = attributes.attribute(COMPRESSION_LEVEL);
    }

    public AuthenticationConfiguration authentication() {
        return this.authentication;
    }

    public ExtendedHeaders extendedHeaders() {
        return (ExtendedHeaders)((Object)this.extendedHeaders.get());
    }

    @Deprecated
    public Set<String> getIgnoredCaches() {
        return this.ignoredCaches();
    }

    public String contextPath() {
        return (String)this.contextPath.get();
    }

    public int maxContentLength() {
        return (Integer)this.maxContentLength.get();
    }

    public List<CorsConfig> getCorsRules() {
        return (List)this.corsRules.get();
    }

    public int getCompressionLevel() {
        return (Integer)this.compressionLevel.get();
    }

    public String toString() {
        return "RestServerConfiguration[" + this.attributes + ", ssl=" + this.ssl + "]";
    }
}

