/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.rest.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.logging.Log;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.util.logging.LogFactory;

public class RestServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<RestServerConfiguration, RestServerConfigurationBuilder>
implements Builder<RestServerConfiguration> {
    static final Log logger = (Log)LogFactory.getLog(RestServerConfigurationBuilder.class, Log.class);
    private final AuthenticationConfigurationBuilder authentication;
    public static final String DEFAULT_CONTEXT_PATH = "rest";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_NAME = "rest";

    public RestServerConfigurationBuilder() {
        super(8080, RestServerConfiguration.attributeDefinitionSet());
        this.name("rest");
        this.authentication = new AuthenticationConfigurationBuilder(this);
    }

    public RestServerConfigurationBuilder extendedHeaders(ExtendedHeaders extendedHeaders) {
        this.attributes.attribute(RestServerConfiguration.EXTENDED_HEADERS).set((Object)extendedHeaders);
        return this;
    }

    public RestServerConfigurationBuilder contextPath(String contextPath) {
        this.attributes.attribute(RestServerConfiguration.CONTEXT_PATH).set((Object)contextPath);
        return this;
    }

    public RestServerConfigurationBuilder maxContentLength(int maxContentLength) {
        this.attributes.attribute(RestServerConfiguration.MAX_CONTENT_LENGTH).set((Object)maxContentLength);
        return this;
    }

    public RestServerConfigurationBuilder compressionLevel(int compressLevel) {
        this.attributes.attribute(RestServerConfiguration.COMPRESSION_LEVEL).set((Object)compressLevel);
        return this;
    }

    public RestServerConfigurationBuilder corsAllowForLocalhost(String scheme, int port) {
        String local1 = scheme + "://127.0.0.1:" + port;
        String local2 = scheme + "://localhost:" + port;
        String local3 = scheme + "://[::1]:" + port;
        CorsConfig corsConfig = CorsConfigBuilder.forOrigins((String[])new String[]{local1, local2, local3}).allowCredentials().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.OPTIONS}).allowedRequestHeaders(new CharSequence[]{HttpHeaderNames.CONTENT_TYPE}).build();
        ((List)this.attributes.attribute(RestServerConfiguration.CORS_RULES).get()).add(corsConfig);
        return this;
    }

    public RestServerConfigurationBuilder addAll(List<CorsConfig> corsConfig) {
        ((List)this.attributes.attribute(RestServerConfiguration.CORS_RULES).get()).addAll(corsConfig);
        return this;
    }

    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public void validate() {
        super.validate();
        this.authentication.validate();
        int compressionLevel = (Integer)this.attributes.attribute(RestServerConfiguration.COMPRESSION_LEVEL).get();
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw logger.illegalCompressionLevel(compressionLevel);
        }
    }

    public RestServerConfiguration create() {
        return new RestServerConfiguration(this.attributes.protect(), this.ssl.create(), this.authentication.create());
    }

    public Builder<?> read(RestServerConfiguration template) {
        super.read((ProtocolServerConfiguration)template);
        return this;
    }

    public RestServerConfiguration build() {
        return this.build(true);
    }

    public RestServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public RestServerConfigurationBuilder self() {
        return this;
    }

    public RestServerConfigurationBuilder defaultCacheName(String defaultCacheName) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder idleTimeout(int idleTimeout) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder tcpKeepAlive(boolean tcpKeepAlive) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder recvBufSize(int recvBufSize) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder sendBufSize(int sendBufSize) {
        throw logger.unsupportedConfigurationOption();
    }
}

