/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.ControlledTransport;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.Exceptions;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.statetransfer.AbstractStateTransferTest;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="rest.XSiteResourceTest")
public class XSiteResourceTest
extends AbstractStateTransferTest {
    private static final String CACHE = XSiteResourceTest.class.getSimpleName();
    private Map<String, RestServerHelper> restServerPerSite = new HashMap<String, RestServerHelper>(2);
    private Map<String, RestClient> clientPerSite = new HashMap<String, RestClient>(2);
    private final ObjectMapper MAPPER = new ObjectMapper();

    public XSiteResourceTest() {
        this.initialClusterSize = 1;
        this.cacheMode = CacheMode.DIST_SYNC;
        this.implicitBackupCache = true;
    }

    @BeforeClass
    public void startServers() {
        this.sites.forEach(site -> {
            String siteName = site.getSiteName();
            EmbeddedCacheManager cm = (EmbeddedCacheManager)site.cacheManagers().iterator().next();
            RestServerHelper restServerHelper = new RestServerHelper(cm);
            restServerHelper.start(TestResourceTracker.getCurrentTestShortName());
            this.restServerPerSite.put(siteName, restServerHelper);
            RestClientConfiguration clientConfig = new RestClientConfigurationBuilder().addServer().host("127.0.0.1").port(restServerHelper.getPort()).build();
            RestClient client = RestClient.forConfiguration((RestClientConfiguration)clientConfig);
            this.clientPerSite.put(siteName, client);
        });
    }

    private RestCacheClient getCacheClient(String site) {
        RestClient restClient = this.clientPerSite.get(site);
        return restClient.cache(CACHE);
    }

    @AfterClass
    public void clean() {
        this.restServerPerSite.values().forEach(RestServerHelper::stop);
        this.clientPerSite.values().forEach(cli -> {
            try {
                cli.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @AfterMethod
    public void cleanCache() {
        XSiteResourceTest.sync(this.getCacheClient("LON-1").clear());
        XSiteResourceTest.sync(this.getCacheClient("NYC-2").clear());
    }

    protected ConfigurationBuilder getNycActiveConfig() {
        return XSiteResourceTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)false);
    }

    protected ConfigurationBuilder getLonActiveConfig() {
        return XSiteResourceTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)false);
    }

    @Test
    public void testObtainBackupStatus() throws Exception {
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus("LON-1"));
        AssertJUnit.assertEquals((String)"online", (String)this.getBackupStatus("NYC-2"));
    }

    @Test
    public void testInvalidCache() {
        RestClient client = this.clientPerSite.get("LON-1");
        RestResponse response = (RestResponse)XSiteResourceTest.sync(client.cache("invalid-cache").xsiteBackups());
        AssertJUnit.assertEquals((int)404, (int)response.getStatus());
    }

    @Test
    public void testInvalidSite() {
        RestClient client = this.clientPerSite.get("LON-1");
        RestCacheClient cache = client.cache(CACHE);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cache.backupStatus("invalid-site"));
        AssertJUnit.assertEquals((int)404, (int)response.getStatus());
    }

    @Test
    public void testOnlineOffline() throws Exception {
        this.testOnlineOffline("LON-1");
        this.testOnlineOffline("NYC-2");
    }

    @Test
    public void testBackups() throws Exception {
        RestCacheClient cache = this.getCacheClient("LON-1");
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cache.xsiteBackups());
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        JsonNode status = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((String)"online", (String)status.get("NYC-2").asText());
    }

    @Test
    public void testPushState() throws Exception {
        RestCacheClient cache = this.getCacheClient("LON-1");
        RestCacheClient backupCache = this.getCacheClient("NYC-2");
        String key = "key";
        String value = "value";
        Function<String, Integer> keyOnBackup = k -> ((RestResponse)XSiteResourceTest.sync(backupCache.get(key))).getStatus();
        this.takeBackupOffline("LON-1");
        AssertJUnit.assertEquals((String)"offline", (String)this.getBackupStatus("LON-1"));
        XSiteResourceTest.sync(cache.put(key, value));
        AssertJUnit.assertEquals((int)404, (int)keyOnBackup.apply(key));
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cache.pushSiteState("NYC-2"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        this.eventually(() -> this.getBackupStatus("LON-1").equals("online"));
        this.eventually(() -> (Integer)keyOnBackup.apply(key) == 200);
    }

    @Test
    public void testCancelPushState() throws Exception {
        RestCacheClient cache = this.getCacheClient("LON-1");
        RestCacheClient backupCache = this.getCacheClient("NYC-2");
        this.takeBackupOffline("LON-1");
        AssertJUnit.assertEquals((String)"offline", (String)this.getBackupStatus("LON-1"));
        int entries = 500;
        IntStream.range(0, entries).forEach(i -> XSiteResourceTest.sync(cache.put(String.valueOf(i), "value")));
        AssertJUnit.assertEquals((int)entries, (int)this.getCacheSize(cache));
        AssertJUnit.assertEquals((int)0, (int)this.getCacheSize(backupCache));
        ControlledTransport controllerTransport = ControlledTransport.replace((Cache)this.cache("LON-1", 0));
        controllerTransport.blockBefore(new Class[]{XSiteStatePushCommand.class});
        XSiteResourceTest.sync(cache.pushSiteState("NYC-2"));
        controllerTransport.waitForCommandToBlock();
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cache.cancelPushState("NYC-2"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        controllerTransport.stopBlocking();
        AssertJUnit.assertEquals((String)"CANCELED", (String)this.getPushStatus("LON-1"));
        response = (RestResponse)XSiteResourceTest.sync(cache.clearPushStateStatus());
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        AssertJUnit.assertEquals((String)"", (String)this.getPushStatus("LON-1"));
        response = (RestResponse)XSiteResourceTest.sync(cache.cancelReceiveState("NYC-2"));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testTakeOfflineConfig() throws Exception {
        RestCacheClient cacheClient = this.getCacheClient("LON-1");
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cacheClient.getXSiteTakeOfflineConfig("NYC-2"));
        JsonNode takeOfflineConfig = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((int)0, (int)takeOfflineConfig.get("afterFailures").asInt());
        AssertJUnit.assertEquals((int)0, (int)takeOfflineConfig.get("minTimeToWait").asInt());
        response = (RestResponse)XSiteResourceTest.sync(cacheClient.updateXSiteTakeOfflineConfig("NYC-2", 5, 1000L));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        response = (RestResponse)XSiteResourceTest.sync(cacheClient.getXSiteTakeOfflineConfig("NYC-2"));
        takeOfflineConfig = this.MAPPER.readTree(response.getBody());
        AssertJUnit.assertEquals((int)5, (int)takeOfflineConfig.get("afterFailures").asInt());
        AssertJUnit.assertEquals((int)1000, (int)takeOfflineConfig.get("minTimeToWait").asInt());
    }

    @Test
    public void testInvalidInputTakeOffline() {
        RestClient restClient = this.clientPerSite.get("LON-1");
        String url = String.format("/rest/v2/caches/%s/x-site/backups/%s/take-offline-config", CACHE, "NYC-2");
        RestResponse response = (RestResponse)XSiteResourceTest.sync(restClient.raw().putValue(url, new HashMap(), "invalid", "application/json"));
        AssertJUnit.assertEquals((int)400, (int)response.getStatus());
    }

    private int getCacheSize(RestCacheClient cacheClient) {
        return Integer.parseInt(((RestResponse)XSiteResourceTest.sync(cacheClient.size())).getBody());
    }

    private String getPushStatus(String site) throws Exception {
        RestCacheClient cache = this.getCacheClient(site);
        String backup = this.getBackup(site);
        JsonNode response = this.MAPPER.readTree(((RestResponse)XSiteResourceTest.sync(cache.pushStateStatus())).getBody());
        if (response.isEmpty()) {
            return "";
        }
        return response.get(backup).asText();
    }

    private void testOnlineOffline(String site) throws Exception {
        this.takeBackupOffline(site);
        String siteStatus = this.getBackupStatus(site);
        AssertJUnit.assertEquals((String)siteStatus, (String)"offline");
        this.bringBackupOnline(site);
        siteStatus = this.getBackupStatus(site);
        AssertJUnit.assertEquals((String)siteStatus, (String)"online");
    }

    private void takeBackupOffline(String site) {
        RestCacheClient client = this.getCacheClient(site);
        String backup = site.equals("LON-1") ? "NYC-2" : "LON-1";
        RestResponse response = (RestResponse)XSiteResourceTest.sync(client.takeSiteOffline(backup));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
    }

    private void bringBackupOnline(String site) {
        RestCacheClient client = this.getCacheClient(site);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(client.bringSiteOnline(this.getBackup(site)));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
    }

    private String getFirstCacheManagerAddress(String site) {
        AbstractXSiteTest.TestSite testSite = this.sites.stream().filter(t -> t.getSiteName().equals(site)).findFirst().orElse(null);
        if (testSite == null) {
            return null;
        }
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)testSite.cacheManagers().iterator().next();
        return cacheManager.getAddress().toString();
    }

    private String getBackupStatus(String site) throws Exception {
        RestCacheClient cacheClient = this.getCacheClient(site);
        RestResponse response = (RestResponse)XSiteResourceTest.sync(cacheClient.backupStatus(this.getBackup(site)));
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        JsonNode json = this.MAPPER.readTree(response.getBody());
        String cacheManagerAddress = this.getFirstCacheManagerAddress(site);
        return json.get(cacheManagerAddress).asText();
    }

    public static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(5L, TimeUnit.SECONDS));
    }

    private String getBackup(String site) {
        if (site.equals("LON-1")) {
            return "NYC-2";
        }
        if (site.equals("NYC-2")) {
            return "LON-1";
        }
        throw new IllegalArgumentException("Invalid site");
    }
}

