/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.RestResponseBuilder;

public class NettyRestResponse
implements RestResponse {
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CLUSTER_PRIMARY_OWNER_HEADER = "Cluster-Primary-Owner";
    private static final String CLUSTER_NODE_NAME_HEADER = "Cluster-Node-Name";
    private static final String CLUSTER_SERVER_ADDRESS_HEADER = "Cluster-Server-Address";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CREATED_HEADER = "created";
    private static final String DATE_HEADER = "Date";
    private static final String ETAG_HEADER = "Etag";
    private static final String EXPIRES_HEADER = "Expires";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String LAST_USED_HEADER = "lastUsed";
    private static final String MAX_IDLE_TIME_HEADER = "maxIdleTimeSeconds";
    private static final String TIME_TO_LIVE_HEADER = "timeToLiveSeconds";
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private final HttpResponse response;
    private final Object entity;

    private NettyRestResponse(HttpResponse response, Object entity) {
        this.response = response;
        this.entity = entity;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public int getStatus() {
        return this.response.status().code();
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    public static class Builder
    implements RestResponseBuilder<Builder> {
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Object entity;
        private HttpResponseStatus httpStatus = HttpResponseStatus.OK;

        @Override
        public NettyRestResponse build() {
            Object response = this.entity instanceof File || this.entity instanceof InputStream ? new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.buffer());
            response.setStatus(this.httpStatus);
            this.headers.forEach((arg_0, arg_1) -> Builder.lambda$build$0((HttpResponse)response, arg_0, arg_1));
            return new NettyRestResponse((HttpResponse)response, this.entity);
        }

        @Override
        public Builder header(String name, Object value) {
            this.setHeader(name, value);
            return this;
        }

        public Builder status(HttpResponseStatus httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        @Override
        public Builder status(int status) {
            this.httpStatus = HttpResponseStatus.valueOf((int)status);
            return this;
        }

        @Override
        public Builder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder eTag(String tag) {
            this.setHeader(NettyRestResponse.ETAG_HEADER, tag);
            return this;
        }

        @Override
        public int getStatus() {
            return this.httpStatus.code();
        }

        @Override
        public Object getEntity() {
            return this.entity;
        }

        @Override
        public Builder contentType(MediaType mediaType) {
            if (mediaType != null) {
                this.contentType(mediaType.toString());
            }
            return this;
        }

        @Override
        public Builder contentType(String mediaType) {
            this.setHeader(NettyRestResponse.CONTENT_TYPE_HEADER, mediaType);
            return this;
        }

        @Override
        public Builder contentLength(long length) {
            this.setLongHeader(NettyRestResponse.CONTENT_LENGTH_HEADER, length);
            return this;
        }

        @Override
        public Builder expires(Date expires) {
            if (expires != null) {
                this.setDateHeader(NettyRestResponse.EXPIRES_HEADER, expires.getTime());
            }
            return this;
        }

        public Builder authenticate(String authentication) {
            if (authentication != null) {
                this.setHeader(NettyRestResponse.WWW_AUTHENTICATE_HEADER, authentication);
            }
            return this;
        }

        @Override
        public Builder lastModified(long epoch) {
            this.setDateHeader(NettyRestResponse.LAST_MODIFIED_HEADER, epoch);
            return this;
        }

        @Override
        public Builder addProcessedDate(Date d) {
            if (d != null) {
                this.setDateHeader(NettyRestResponse.DATE_HEADER, d.getTime());
            }
            return this;
        }

        @Override
        public Builder cacheControl(CacheControl cacheControl) {
            if (cacheControl != null) {
                this.setHeader(NettyRestResponse.CACHE_CONTROL_HEADER, cacheControl.toString());
            }
            return this;
        }

        @Override
        public Object getHeader(String header) {
            return this.headers.get(header);
        }

        public Builder timeToLive(long timeToLive) {
            if (timeToLive > -1L) {
                this.setLongHeader(NettyRestResponse.TIME_TO_LIVE_HEADER, TimeUnit.MILLISECONDS.toSeconds(timeToLive));
            }
            return this;
        }

        public Builder maxIdle(long maxIdle) {
            if (maxIdle > -1L) {
                this.setLongHeader(NettyRestResponse.MAX_IDLE_TIME_HEADER, TimeUnit.MILLISECONDS.toSeconds(maxIdle));
            }
            return this;
        }

        public Builder created(long created) {
            if (created > -1L) {
                this.setHeader(NettyRestResponse.CREATED_HEADER, String.valueOf(created));
            }
            return this;
        }

        public Builder lastUsed(long lastUsed) {
            if (lastUsed > -1L) {
                this.setHeader(NettyRestResponse.LAST_USED_HEADER, String.valueOf(lastUsed));
            }
            return this;
        }

        public Builder clusterPrimaryOwner(String primaryOwner) {
            this.setHeader(NettyRestResponse.CLUSTER_PRIMARY_OWNER_HEADER, primaryOwner);
            return this;
        }

        public Builder clusterNodeName(String nodeName) {
            this.setHeader(NettyRestResponse.CLUSTER_NODE_NAME_HEADER, nodeName);
            return this;
        }

        public Builder clusterServerAddress(String serverAddress) {
            this.setHeader(NettyRestResponse.CLUSTER_SERVER_ADDRESS_HEADER, serverAddress);
            return this;
        }

        public HttpResponseStatus getHttpStatus() {
            return this.httpStatus;
        }

        private void setHeader(String name, Object value) {
            if (value != null) {
                this.headers.computeIfAbsent(name, a -> new ArrayList()).add(value.toString());
            }
        }

        private void setLongHeader(String name, long value) {
            this.headers.computeIfAbsent(name, a -> new ArrayList()).add(String.valueOf(value));
        }

        private void setDateHeader(String name, Long epoch) {
            if (epoch != null) {
                String value = DateUtils.toRFC1123(epoch);
                this.setHeader(name, value);
            }
        }

        private static /* synthetic */ void lambda$build$0(HttpResponse response, String name, List values) {
            response.headers().set(name, (Iterable)values);
        }
    }
}

