/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RegistrationException;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String unsupportedConfigurationOption = "ISPN012004: Unsupported configuration option";
    private static final String errorWhileResponding = "ISPN012005: An error occurred while responding to the client";
    private static final String uncaughtExceptionInThePipeline = "ISPN012006: Uncaught exception in the pipeline";
    private static final String unsupportedDataFormat = "ISPN012007: Cannot convert to %s";
    private static final String cacheUnavailable = "ISPN012008: Cache with name '%s' is temporarily unavailable.";
    private static final String missingRequiredMediaType = "ISPN012009: Cannot obtain cache '%s', without required MediaType";
    private static final String cacheNotFound = "ISPN012010: Cache with name '%s' not found amongst the configured caches";
    private static final String requestNotAllowedToInternalCaches = "ISPN012011: Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'";
    private static final String requestNotAllowedToInternalCachesWithoutAuthz = "ISPN012012: Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'";
    private static final String illegalCompressionLevel = "ISPN012014: Illegal compression level '%d'. The value must be >= 0 and <= 9";
    private static final String duplicateResourceMethod = "ISPN012015: Cannot register invocation '%s': resource already registered for method '%s' at the destination path '/%s'";
    private static final String warnInvalidNumber = "ISPN012016: Header '%s' will be ignored, expecting a number but got '%s'";
    private static final String authenticationWithoutAuthenticator = "ISPN012017: Cannot enable authentication without an authenticator";
    private static final String invalidPath = "ISPN012018: Cannot register invocation with path '%s': '*' is only allowed at the end";
    private static final String duplicateResource = "ISPN012019: Cannot register path '%s' for invocation '%s', since it conflicts with already registered path '%s'";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unsupportedConfigurationOption$str() {
        return unsupportedConfigurationOption;
    }

    @Override
    public final UnsupportedOperationException unsupportedConfigurationOption() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedConfigurationOption$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void errorWhileResponding(Exception e) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)e, this.errorWhileResponding$str(), new Object[0]);
    }

    protected String errorWhileResponding$str() {
        return errorWhileResponding;
    }

    @Override
    public final void uncaughtExceptionInThePipeline(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.uncaughtExceptionInThePipeline$str(), new Object[0]);
    }

    protected String uncaughtExceptionInThePipeline$str() {
        return uncaughtExceptionInThePipeline;
    }

    protected String unsupportedDataFormat$str() {
        return unsupportedDataFormat;
    }

    @Override
    public final UnacceptableDataFormatException unsupportedDataFormat(String mediaType) {
        UnacceptableDataFormatException result = new UnacceptableDataFormatException(String.format(this.getLoggingLocale(), this.unsupportedDataFormat$str(), mediaType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cacheUnavailable$str() {
        return cacheUnavailable;
    }

    @Override
    public final ServiceUnavailableException cacheUnavailable(String cacheName) {
        ServiceUnavailableException result = new ServiceUnavailableException(String.format(this.getLoggingLocale(), this.cacheUnavailable$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingRequiredMediaType$str() {
        return missingRequiredMediaType;
    }

    @Override
    public final NullPointerException missingRequiredMediaType(String cacheName) {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.missingRequiredMediaType$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cacheNotFound$str() {
        return cacheNotFound;
    }

    @Override
    public final NoCacheFoundException cacheNotFound(String cacheName) {
        NoCacheFoundException result = new NoCacheFoundException(String.format(this.getLoggingLocale(), this.cacheNotFound$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestNotAllowedToInternalCaches$str() {
        return requestNotAllowedToInternalCaches;
    }

    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCaches(String cacheName) {
        CacheUnavailableException result = new CacheUnavailableException(String.format(this.getLoggingLocale(), this.requestNotAllowedToInternalCaches$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestNotAllowedToInternalCachesWithoutAuthz$str() {
        return requestNotAllowedToInternalCachesWithoutAuthz;
    }

    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(String cacheName) {
        CacheUnavailableException result = new CacheUnavailableException(String.format(this.getLoggingLocale(), this.requestNotAllowedToInternalCachesWithoutAuthz$str(), cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalCompressionLevel$str() {
        return illegalCompressionLevel;
    }

    @Override
    public final CacheConfigurationException illegalCompressionLevel(int compressionLevel) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.illegalCompressionLevel$str(), compressionLevel));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateResourceMethod$str() {
        return duplicateResourceMethod;
    }

    @Override
    public final RegistrationException duplicateResourceMethod(String invocationName, Method method, String existingPath) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.duplicateResourceMethod$str(), new Object[]{invocationName, method, existingPath}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void warnInvalidNumber(String header, String value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidNumber$str(), (Object)header, (Object)value);
    }

    protected String warnInvalidNumber$str() {
        return warnInvalidNumber;
    }

    protected String authenticationWithoutAuthenticator$str() {
        return authenticationWithoutAuthenticator;
    }

    @Override
    public final CacheConfigurationException authenticationWithoutAuthenticator() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.authenticationWithoutAuthenticator$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPath$str() {
        return invalidPath;
    }

    @Override
    public final RegistrationException invalidPath(String path) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.invalidPath$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateResource$str() {
        return duplicateResource;
    }

    @Override
    public final RegistrationException duplicateResource(String candidate, Invocation invocation, String existingPath) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.duplicateResource$str(), candidate, invocation, existingPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

