/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.JVMMemoryInfoInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.server.core.ServerManagement;

public class ServerResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private static final int SHUTDOWN_DELAY_SECONDS = 3;
    private static final ServerInfo SERVER_INFO = new ServerInfo();

    public ServerResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/server/").handleWith(this::info).invocation().methods(Method.GET).path("/v2/server/config").handleWith(this::config).invocation().methods(Method.GET).path("/v2/server/env").handleWith(this::env).invocation().methods(Method.GET).path("/v2/server/memory").handleWith(this::memory).invocation().methods(Method.GET).path("/v2/server/stop").handleWith(this::stop).invocation().methods(Method.GET).path("/v2/server/threads").handleWith(this::threads).invocation().methods(Method.GET).path("/v2/server/cache-managers").handleWith(this::cacheManagers).invocation().methods(Method.GET).path("/v2/server/ignored-caches/{cache-manager}").handleWith(this::listIgnored).invocation().methods(Method.POST, Method.DELETE).path("/v2/server/ignored-caches/{cache-manager}/{cache}").handleWith(this::doIgnoreOp).create();
    }

    private CompletionStage<RestResponse> doIgnoreOp(RestRequest restRequest) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        boolean add = restRequest.method().equals((Object)Method.POST);
        String cacheManagerName = restRequest.variables().get("cache-manager");
        DefaultCacheManager cacheManager = this.invocationHelper.getServer().getCacheManager(cacheManagerName);
        if (cacheManager == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        String cacheName = restRequest.variables().get("cache");
        if (!cacheManager.getCacheNames().contains(cacheName)) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        ServerManagement server = this.invocationHelper.getServer();
        if (add) {
            return server.ignoreCache(cacheManagerName, cacheName).thenApply(r -> builder.build());
        }
        return server.unIgnoreCache(cacheManagerName, cacheName).thenApply(r -> builder.build());
    }

    private CompletionStage<RestResponse> listIgnored(RestRequest restRequest) {
        String cacheManagerName = restRequest.variables().get("cache-manager");
        DefaultCacheManager cacheManager = this.invocationHelper.getServer().getCacheManager(cacheManagerName);
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        if (cacheManager == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        return this.invocationHelper.getServer().ignoredCaches(cacheManagerName).thenApply(ignored -> {
            try {
                byte[] resultBytes = this.invocationHelper.getMapper().writeValueAsBytes(ignored);
                builder.contentType("application/json").entity(resultBytes);
            }
            catch (JsonProcessingException e) {
                builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(e.getMessage());
            }
            return builder.build();
        });
    }

    private CompletionStage<RestResponse> cacheManagers(RestRequest restRequest) {
        return this.serializeObject(this.invocationHelper.getServer().cacheManagerNames());
    }

    private CompletionStage<RestResponse> memory(RestRequest restRequest) {
        return this.serializeObject(new JVMMemoryInfoInfo());
    }

    private CompletionStage<RestResponse> env(RestRequest restRequest) {
        return this.serializeObject(ManagementFactory.getRuntimeMXBean().getSystemProperties());
    }

    private CompletionStage<RestResponse> info(RestRequest restRequest) {
        return this.serializeObject(SERVER_INFO);
    }

    private CompletionStage<RestResponse> threads(RestRequest restRequest) {
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().contentType(MediaType.TEXT_PLAIN).entity(Util.threadDump()).build());
    }

    private CompletionStage<RestResponse> serializeObject(Object object) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        try {
            byte[] bytes = this.invocationHelper.getMapper().writeValueAsBytes(object);
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> stop(RestRequest restRequest) {
        this.invocationHelper.getScheduledExecutor().schedule(() -> this.invocationHelper.getServer().stop(), 3L, TimeUnit.SECONDS);
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().build());
    }

    private CompletionStage<RestResponse> config(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String json = this.invocationHelper.getJsonWriter().toJSON(this.invocationHelper.getServer().getConfiguration());
        responseBuilder.entity(json).contentType(MediaType.APPLICATION_JSON);
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    static class ServerInfo {
        final String version = Version.printVersion();

        ServerInfo() {
        }

        public String getVersion() {
            return this.version;
        }
    }
}

