/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;

public class StaticFileResource
implements ResourceHandler {
    private final Path dir;
    private final String urlPath;
    private static final int CACHE_TIME = 2678400;
    private static final String DEFAULT_RESOURCE = "index.html";

    public StaticFileResource(Path dir, String urlPath) {
        this.dir = dir.toAbsolutePath();
        this.urlPath = urlPath;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path(this.urlPath + "/").path(this.urlPath + "/*").handleWith(this::serveFile).create();
    }

    private File resolve(String resource) {
        Path resolved = this.dir.resolve(resource);
        try {
            if (!resolved.toFile().getCanonicalPath().startsWith(this.dir.toAbsolutePath().toString())) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        File file = resolved.toFile();
        if (!file.isFile() || !file.exists()) {
            return null;
        }
        return file;
    }

    private CompletionStage<RestResponse> serveFile(RestRequest restRequest) {
        boolean isNotModified;
        File file;
        String resource;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String uri = restRequest.uri();
        String string = resource = uri.equals("/" + this.urlPath) ? "" : uri.substring(uri.indexOf(this.urlPath) + this.urlPath.length() + 1);
        if (resource.isEmpty()) {
            resource = DEFAULT_RESOURCE;
        }
        if ((file = this.resolve(resource)) == null) {
            return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        String ifModifiedSince = restRequest.getIfModifiedSinceHeader();
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (isNotModified = DateUtils.isNotModifiedSince(ifModifiedSince, file.lastModified()))) {
            responseBuilder.status(HttpResponseStatus.NOT_MODIFIED);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        responseBuilder.lastModified(file.lastModified());
        responseBuilder.header("Cache-control", "private, max-age=2678400");
        responseBuilder.header("X-Frame-Options", "sameorigin");
        responseBuilder.header("X-XSS-Protection", "1; mode=block");
        responseBuilder.header("X-Content-Type-Options", "nosniff");
        Date now = new Date();
        responseBuilder.addProcessedDate(now);
        responseBuilder.header("Expires", DateUtils.toRFC1123(now.getTime() + TimeUnit.SECONDS.toMillis(2678400L)));
        String mediaType = "application/octet-stream";
        try {
            String probed = Files.probeContentType(file.toPath());
            if (probed != null) {
                mediaType = probed;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        responseBuilder.contentLength(file.length()).contentType(mediaType).entity(file);
        return CompletableFuture.completedFuture(responseBuilder.build());
    }
}

