/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import java.io.IOException;
import java.nio.file.Path;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.RestChannelInitializer;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.AuthenticationConfiguration;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestDispatcher;
import org.infinispan.rest.framework.impl.ResourceManagerImpl;
import org.infinispan.rest.framework.impl.RestDispatcherImpl;
import org.infinispan.rest.resources.CacheManagerResource;
import org.infinispan.rest.resources.CacheResource;
import org.infinispan.rest.resources.CacheResourceV2;
import org.infinispan.rest.resources.ClusterResource;
import org.infinispan.rest.resources.CounterResource;
import org.infinispan.rest.resources.MetricsResource;
import org.infinispan.rest.resources.ServerResource;
import org.infinispan.rest.resources.SplashResource;
import org.infinispan.rest.resources.StaticFileResource;
import org.infinispan.rest.resources.XSiteResource;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;

public class RestServer
extends AbstractProtocolServer<RestServerConfiguration> {
    private ServerManagement server;
    private RestDispatcher restDispatcher;
    private RestCacheManager<Object> restCacheManager;
    private InvocationHelper invocationHelper;

    public RestServer() {
        super("REST");
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{this.getRestChannelInitializer()});
    }

    public RestChannelInitializer getRestChannelInitializer() {
        return new RestChannelInitializer(this, this.transport);
    }

    RestDispatcher getRestDispatcher() {
        return this.restDispatcher;
    }

    public void stop() {
        AuthenticationConfiguration auth;
        if (this.restCacheManager != null) {
            this.restCacheManager.stop();
        }
        if ((auth = ((RestServerConfiguration)this.configuration).authentication()).enabled()) {
            try {
                auth.authenticator().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.stop();
    }

    public void setServer(ServerManagement server) {
        this.server = server;
    }

    protected void startInternal(RestServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        this.configuration = configuration;
        AuthenticationConfiguration auth = configuration.authentication();
        if (auth.enabled()) {
            auth.authenticator().init(this);
        }
        super.startInternal((ProtocolServerConfiguration)configuration, cacheManager);
        this.restCacheManager = new RestCacheManager(cacheManager, arg_0 -> ((RestServer)this).isCacheIgnored(arg_0));
        this.invocationHelper = new InvocationHelper(this.restCacheManager, (EmbeddedCounterManager)EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager), configuration, this.server, this.getExecutor());
        String restContext = configuration.contextPath();
        String rootContext = "/";
        ResourceManagerImpl resourceManager = new ResourceManagerImpl();
        resourceManager.registerResource(rootContext, new SplashResource());
        resourceManager.registerResource(restContext, new CacheResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new CacheResourceV2(this.invocationHelper));
        resourceManager.registerResource(restContext, new CounterResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new CacheManagerResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new XSiteResource(this.invocationHelper));
        resourceManager.registerResource(rootContext, new MetricsResource());
        Path staticResources = configuration.staticResources();
        if (staticResources != null) {
            resourceManager.registerResource(rootContext, new StaticFileResource(staticResources, "static"));
        }
        if (this.server != null) {
            resourceManager.registerResource(restContext, new ServerResource(this.invocationHelper));
            resourceManager.registerResource(restContext, new ClusterResource(this.invocationHelper));
        }
        this.restDispatcher = new RestDispatcherImpl(resourceManager);
    }
}

