/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.impl.ClientCertAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestResourceTracker;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CertificateTest")
public class CertificateTest
extends AbstractInfinispanTest {
    public static final String TRUST_STORE_PATH = CertificateTest.class.getClassLoader().getResource("./client.p12").getPath();
    public static final String KEY_STORE_PATH = CertificateTest.class.getClassLoader().getResource("./client.p12").getPath();
    private HttpClient client;
    private RestServerHelper restServer;

    @AfterSuite
    public void afterSuite() throws Exception {
        this.restServer.stop();
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        if (this.restServer != null) {
            this.restServer.stop();
        }
        this.client.stop();
    }

    @Test
    public void shouldAllowProperCertificate() throws Exception {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setTrustStorePassword(TRUST_STORE_PATH);
        sslContextFactory.setTrustStorePassword("secret");
        sslContextFactory.setTrustStoreType("pkcs12");
        sslContextFactory.setKeyStorePath(KEY_STORE_PATH);
        sslContextFactory.setKeyStorePassword("secret");
        sslContextFactory.setKeyStoreType("pkcs12");
        this.client = new HttpClient(sslContextFactory);
        this.client.start();
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)new ClientCertAuthenticator()).withKeyStore(KEY_STORE_PATH, "secret", "pkcs12").withTrustStore(TRUST_STORE_PATH, "secret", "pkcs12").withClientAuth().start(TestResourceTracker.getCurrentTestShortName());
        ContentResponse response = this.client.newRequest(String.format("https://localhost:%d/rest/v2/caches/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }
}

