/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.assertion;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.DateUtils;

public class ResponseAssertion {
    private ContentResponse response;

    private ResponseAssertion(ContentResponse response) {
        this.response = response;
    }

    public static ResponseAssertion assertThat(ContentResponse response) {
        return new ResponseAssertion(response);
    }

    public ResponseAssertion isOk() {
        Assertions.assertThat((int)this.response.getStatus()).isBetween(Integer.valueOf(200), Integer.valueOf(204));
        return this;
    }

    public ResponseAssertion isRedirect() {
        Assertions.assertThat((int)this.response.getStatus()).isIn(new Object[]{301, 302, 307, 308});
        return this;
    }

    public ResponseAssertion doesntExist() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(404);
        return this;
    }

    public ResponseAssertion hasReturnedText(String text) {
        Assertions.assertThat((String)this.response.getContentAsString()).isEqualTo((Object)text);
        return this;
    }

    public ResponseAssertion hasReturnedText(String ... textPossibilities) {
        Assertions.assertThat((String)this.response.getContentAsString()).matches(s -> {
            for (String possible : textPossibilities) {
                if (!s.equals(possible)) continue;
                return true;
            }
            return false;
        }, "Content: " + this.response.getContentAsString() + " doesn't match any of " + textPossibilities);
        return this;
    }

    public ResponseAssertion containsReturnedText(String text) {
        Assertions.assertThat((String)this.response.getContentAsString()).contains(new CharSequence[]{text});
        return this;
    }

    public ResponseAssertion bodyNotEmpty() {
        Assertions.assertThat((String)this.response.getContentAsString()).isNotEmpty();
        return this;
    }

    public ResponseAssertion hasEtag() {
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get(HttpHeader.ETAG)).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion hasNoContent() {
        Assertions.assertThat((String)this.response.getContentAsString()).isEmpty();
        return this;
    }

    public ResponseAssertion hasNoContentType() {
        Assertions.assertThat((String)this.response.getHeaders().get(HttpHeader.CONTENT_TYPE)).isNull();
        return this;
    }

    public ResponseAssertion hasNoContentEncoding() {
        Assertions.assertThat((String)this.response.getHeaders().get(HttpHeader.CONTENT_ENCODING)).isNull();
        return this;
    }

    public ResponseAssertion hasContentType(String contentType) {
        Assertions.assertThat((String)this.response.getHeaders().get(HttpHeader.CONTENT_TYPE).replace(" ", "")).contains(new CharSequence[]{contentType.replace(" ", "")});
        return this;
    }

    public ResponseAssertion hasContentLength(Integer value) {
        Assertions.assertThat((String)this.response.getHeaders().get("Content-Length")).isEqualTo((Object)value.toString());
        return this;
    }

    public ResponseAssertion hasContentLength(Long value) {
        Assertions.assertThat((String)this.response.getHeaders().get("Content-Length")).isEqualTo((Object)value.toString());
        return this;
    }

    public ResponseAssertion hasGzipContentEncoding() {
        Assertions.assertThat((String)this.response.getHeaders().get("Content-Encoding")).isEqualTo((Object)"gzip");
        return this;
    }

    public ResponseAssertion hasHeaderMatching(String header, String regexp) {
        Assertions.assertThat((String)this.response.getHeaders().get(header)).matches((CharSequence)regexp);
        return this;
    }

    public ResponseAssertion containsAllHeaders(String ... headers) {
        Assertions.assertThat(this.response.getHeaders().stream().map(HttpField::getName)).contains((Object[])headers);
        return this;
    }

    public ResponseAssertion hasCacheControlHeaders(String ... directives) {
        List valueList = this.response.getHeaders().getValuesList(HttpHeader.CACHE_CONTROL);
        Assertions.assertThat((List)valueList).isEqualTo(Arrays.asList(directives));
        return this;
    }

    public ResponseAssertion hasExtendedHeaders() {
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get("Cluster-Primary-Owner")).isNotNull()).isNotEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get("Cluster-Node-Name")).isNotNull()).isNotEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get("Cluster-Server-Address")).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion isConflicted() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(409);
        return this;
    }

    public ResponseAssertion isError() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(500);
        return this;
    }

    public ResponseAssertion isUnauthorized() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(401);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.response.getHeaders().get(HttpHeader.WWW_AUTHENTICATE)).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion isNotFound() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(404);
        return this;
    }

    public ResponseAssertion isPayloadTooLarge() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(413);
        return this;
    }

    public ResponseAssertion isNotModified() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(304);
        return this;
    }

    public ResponseAssertion hasContentEqualToFile(String fileName) {
        try {
            Path path = Paths.get(this.getClass().getClassLoader().getResource(fileName).toURI());
            byte[] loadedFile = Files.readAllBytes(path);
            Assertions.assertThat((byte[])this.response.getContent()).isEqualTo((Object)loadedFile);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public ResponseAssertion isNotAcceptable() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(406);
        return this;
    }

    public ResponseAssertion isBadRequest() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(400);
        return this;
    }

    public ResponseAssertion hasNoCharset() {
        Assertions.assertThat((String)this.response.getHeaders().get(HttpHeader.CONTENT_TYPE)).doesNotContain((CharSequence)"charset");
        return this;
    }

    public ResponseAssertion hasReturnedBytes(byte[] bytes) {
        Assertions.assertThat((byte[])this.response.getContent()).containsExactly(bytes);
        return this;
    }

    public ResponseAssertion isServiceUnavailable() {
        Assertions.assertThat((int)this.response.getStatus()).isEqualTo(503);
        return this;
    }

    public ResponseAssertion hasMediaType(MediaType[] mediaType) {
        boolean hasMatches = Arrays.stream(mediaType).anyMatch(m -> MediaType.fromString((String)this.response.getMediaType()).match(m));
        Assertions.assertThat((boolean)hasMatches).isTrue();
        return this;
    }

    public ResponseAssertion hasValidDate() {
        String dateHeader = this.response.getHeaders().get("date");
        ZonedDateTime zonedDateTime = DateUtils.parseRFC1123((String)dateHeader);
        Assertions.assertThat((ZonedDateTime)zonedDateTime).isNotNull();
        return this;
    }

    public ResponseAssertion hasLastModified(long timestamp) {
        String dateHeader = this.response.getHeaders().get(HttpHeaderNames.LAST_MODIFIED.toString());
        Assertions.assertThat((String)dateHeader).isNotNull();
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault());
        String value = DateTimeFormatter.RFC_1123_DATE_TIME.format(zonedDateTime);
        Assertions.assertThat((String)value).isEqualTo((Object)dateHeader);
        return this;
    }

    public ResponseAssertion expiresAfter(int expireDuration) {
        String dateHeader = this.response.getHeaders().get(HttpHeaderNames.DATE.toString());
        String expiresHeader = this.response.getHeaders().get(HttpHeaderNames.EXPIRES.toString());
        ZonedDateTime date = DateUtils.parseRFC1123((String)dateHeader);
        ZonedDateTime expires = DateUtils.parseRFC1123((String)expiresHeader);
        ZonedDateTime diff = expires.minus(expireDuration, ChronoUnit.SECONDS);
        Assertions.assertThat((ZonedDateTime)diff).isEqualTo(date);
        return this;
    }
}

