/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.helper;

import java.net.URISyntaxException;
import java.nio.file.Paths;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public class RestServerHelper {
    private final EmbeddedCacheManager cacheManager;
    private final RestServer restServer = new RestServer();
    private final RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();

    public RestServerHelper(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        try {
            ((RestServerConfigurationBuilder)((RestServerConfigurationBuilder)this.restServerConfigurationBuilder.host("localhost")).port(0)).maxContentLength(1000000).staticResources(Paths.get(this.getClass().getResource("/static-test").toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public static RestServerHelper defaultRestServer(String ... cachesDefined) {
        return RestServerHelper.defaultRestServer(new ConfigurationBuilder(), cachesDefined);
    }

    public RestServerHelper withConfiguration(RestServerConfiguration configuration) {
        this.restServerConfigurationBuilder.read(configuration);
        return this;
    }

    public static RestServerHelper defaultRestServer(ConfigurationBuilder configuration, String ... cachesDefined) {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
        cacheManager.getClassWhiteList().addClasses(new Class[]{TestClass.class});
        for (String cacheConfiguration : cachesDefined) {
            cacheManager.defineConfiguration(cacheConfiguration, configuration.build());
        }
        return new RestServerHelper(cacheManager);
    }

    public RestServerHelper withAuthenticator(Authenticator authenticator) {
        this.restServerConfigurationBuilder.authentication().authenticator(authenticator);
        return this;
    }

    public RestServerHelper start(String name) {
        this.restServerConfigurationBuilder.name(name);
        this.restServer.start((ProtocolServerConfiguration)this.restServerConfigurationBuilder.build(), this.cacheManager);
        return this;
    }

    public void clear() {
        InternalCacheRegistry registry = (InternalCacheRegistry)this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        this.cacheManager.getCacheNames().stream().filter(cacheName -> !registry.isInternalCache(cacheName)).forEach(cacheName -> this.cacheManager.getCache(cacheName).getAdvancedCache().getDataContainer().clear());
    }

    public void stop() {
        this.restServer.stop();
        this.cacheManager.stop();
    }

    public int getPort() {
        return this.restServer.getPort();
    }

    public RestServerConfiguration getConfiguration() {
        return (RestServerConfiguration)this.restServer.getConfiguration();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getBasePath() {
        return String.format("/%s/v2/caches/%s", ((RestServerConfiguration)this.restServer.getConfiguration()).contextPath(), this.cacheManager.getCacheManagerConfiguration().defaultCacheName().get());
    }

    public RestServerHelper withKeyStore(String keyStorePath, String secret, String type) {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().keyStoreFileName(keyStorePath).keyStorePassword(secret.toCharArray()).keyStoreType(type);
        return this;
    }

    public RestServerHelper withTrustStore(String trustStorePath, String secret, String type) {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().trustStoreFileName(trustStorePath).trustStorePassword(secret.toCharArray()).trustStoreType(type);
        return this;
    }

    public RestServerHelper withClientAuth() {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().requireClientAuth(true);
        return this;
    }

    public String getHost() {
        return this.restServer.getHost();
    }

    public void ignoreCache(String cacheName) {
        this.restServer.getCacheIgnore().ignoreCache(cacheName);
    }

    public void unignoreCache(String cacheName) {
        this.restServer.getCacheIgnore().unignoreCache(cacheName);
    }
}

