/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.dataconversion.Gzip;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.rest.resources.BaseCacheResourceTest;
import org.infinispan.rest.search.entity.Person;
import org.infinispan.server.core.dataconversion.JsonTranscoder;
import org.infinispan.server.core.dataconversion.XMLTranscoder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CacheResourceTest")
public class CacheResourceTest
extends BaseCacheResourceTest {
    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        super.defineCaches(cm);
        ConfigurationBuilder object = this.getDefaultCacheBuilder();
        object.encoding().key().mediaType("text/plain");
        object.encoding().value().mediaType("application/x-java-object");
        ConfigurationBuilder legacyStorageCache = this.getDefaultCacheBuilder();
        legacyStorageCache.encoding().key().mediaType("application/x-java-object;type=java.lang.String");
        cm.defineConfiguration("objectCache", object.build());
        cm.defineConfiguration("legacy", legacyStorageCache.build());
        cm.defineConfiguration("rest", this.getDefaultCacheBuilder().build());
    }

    @Test
    public void testLegacyPredefinedCache() throws Exception {
        this.putStringValueInCache("rest", "k1", "v1");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "rest", "k1")).send();
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void shouldReadWriteToLegacyCache() throws Exception {
        this.putStringValueInCache("legacy", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "legacy", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToJson() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test".getBytes(), testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "objectCache", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"" + TestClass.class.getName() + "\",\"name\":\"test\"}");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToXml() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test".getBytes(), testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "objectCache", "test")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<?xml version=\"1.0\" ?><org.infinispan.rest.TestClass><name>test</name></org.infinispan.rest.TestClass>");
    }

    @Test
    public void shouldReadAsBinaryWithPojoCache() throws Exception {
        String cacheName = "pojoCache";
        String key = "test";
        TestClass value = new TestClass();
        value.setName("test");
        this.putValueInCache(cacheName, key, value);
        ContentResponse response = this.get(cacheName, key, "application/octet-stream");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadTextWithPojoCache() throws Exception {
        String cacheName = "pojoCache";
        String key = "k1";
        String value = "v1";
        this.putValueInCache(cacheName, key, value);
        ContentResponse response = this.get(cacheName, key, "text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void shouldReadByteArrayWithPojoCache() throws Exception {
        AdvancedCache cache = this.restServer().getCacheManager().getCache("pojoCache").getAdvancedCache().withEncoding(IdentityEncoder.class);
        cache.put((Object)"k1", (Object)"v1".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "pojoCache", "k1")).header(HttpHeader.ACCEPT, "application/octet-stream").send();
        ResponseAssertion.assertThat(response).hasReturnedBytes("v1".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadAsJsonWithPojoCache() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("pojoCache", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "pojoCache", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test\"}");
    }

    @Test
    public void shouldNegotiateFromPojoCacheWithoutAccept() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        String cacheName = "pojoCache";
        String key = "k1";
        this.putValueInCache(cacheName, key, testClass);
        ContentResponse response = this.get(cacheName, key, null);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(testClass.toString());
    }

    @Test
    public void shouldWriteTextContentWithPjoCache() throws Exception {
        this.putStringValueInCache("pojoCache", "key1", "data");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "pojoCache", "key1")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("data");
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
    }

    @Test
    public void shouldWriteOctetStreamToDefaultCache() throws Exception {
        this.putBinaryValueInCache("default", "keyA", "<hey>ho</hey>".getBytes(), MediaType.APPLICATION_OCTET_STREAM);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "default", "keyA")).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedBytes("<hey>ho</hey>".getBytes());
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldIgnoreDisabledCaches() throws Exception {
        this.putStringValueInCache("default", "K", "V");
        String url = String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "default", "K");
        ContentResponse response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
        this.restServer().ignoreCache("default");
        response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isServiceUnavailable();
        this.restServer().unignoreCache("default");
        response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void shouldDeleteExistingValueEvenWithoutMetadata() throws Exception {
        this.putValueInCache("default", "test".getBytes(), "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "default", "test")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer().getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void testCORSPreflight() throws Exception {
        this.putValueInCache("default", "key", "value");
        int port = this.restServer().getPort();
        ContentResponse preFlight = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", port, "default", "key")).method(HttpMethod.OPTIONS).header(HttpHeader.HOST, "localhost").header(HttpHeader.ORIGIN, "http://localhost:" + port).header("access-control-request-method", "GET").send();
        ResponseAssertion.assertThat(preFlight).isOk();
        ResponseAssertion.assertThat(preFlight).hasNoContent();
        ResponseAssertion.assertThat(preFlight).containsAllHeaders("access-control-allow-origin", "access-control-allow-methods");
    }

    @Test
    public void testCorsGET() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        int port = this.restServer().getPort();
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", port, "default", "test")).header(HttpHeader.ORIGIN, "http://127.0.0.1:" + port).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsAllHeaders("access-control-allow-origin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCORSAllOrigins() throws Exception {
        RestServerHelper restServerHelper = null;
        try {
            RestServerConfigurationBuilder restBuilder = new RestServerConfigurationBuilder();
            restBuilder.cors().addNewRule().allowOrigins(new String[]{"*"});
            ((RestServerConfigurationBuilder)restBuilder.host("localhost")).port(0);
            restServerHelper = RestServerHelper.defaultRestServer(new String[0]);
            RestServerConfiguration build = restBuilder.build();
            restServerHelper.withConfiguration(build).start("test");
            ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", restServerHelper.getPort(), "default", "test")).header(HttpHeader.ORIGIN, "http://host.example.com:5576").send();
            ResponseAssertion.assertThat(response).containsAllHeaders("access-control-allow-origin");
        }
        finally {
            if (restServerHelper != null) {
                restServerHelper.stop();
            }
        }
    }

    @Test
    public void testIfModifiedHeaderForCache() throws Exception {
        this.putStringValueInCache("expiration", "test", "test");
        String url = String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "expiration", "test");
        ContentResponse resp = this.client.newRequest(url).send();
        String dateLast = resp.getHeaders().get("Last-Modified");
        ContentResponse sameLastModAndIfModified = this.client.newRequest(url).header("If-Modified-Since", dateLast).send();
        ResponseAssertion.assertThat(sameLastModAndIfModified).isNotModified();
        this.putStringValueInCache("expiration", "test", "test-new");
        ContentResponse lastmodAfterIfModified = this.client.newRequest(url).send();
        dateLast = lastmodAfterIfModified.getHeaders().get("Last-Modified");
        ResponseAssertion.assertThat(lastmodAfterIfModified).isOk();
        ContentResponse lastmodBeforeIfModified = this.client.newRequest(url).header("If-Modified-Since", this.plus1Day(dateLast)).send();
        ResponseAssertion.assertThat(lastmodBeforeIfModified).isNotModified();
    }

    private String plus1Day(String rfc1123Date) {
        ZonedDateTime plus = DateUtils.parseRFC1123((String)rfc1123Date).plus(1L, ChronoUnit.DAYS);
        return DateUtils.toRFC1123((long)(plus.toEpochSecond() * 1000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompression() throws Exception {
        String payload = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.putStringValueInCache("default", "k", payload);
        HttpClient uncompressingClient = new HttpClient();
        try {
            uncompressingClient.start();
            uncompressingClient.getContentDecoderFactories().clear();
            ContentResponse response = uncompressingClient.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "default", "k")).header(HttpHeader.ACCEPT, "text/plain").send();
            ResponseAssertion.assertThat(response).hasNoContentEncoding();
            ResponseAssertion.assertThat(response).hasContentLength(payload.getBytes().length);
            this.client.getContentDecoderFactories().clear();
            response = uncompressingClient.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "default", "k")).header(HttpHeader.ACCEPT, "text/plain").header(HttpHeader.ACCEPT_ENCODING, "gzip").send();
            ResponseAssertion.assertThat(response).hasGzipContentEncoding();
            AssertJUnit.assertEquals((String)Gzip.decompress((byte[])response.getContent()), (String)payload);
        }
        finally {
            uncompressingClient.stop();
        }
    }

    @Test
    public void testReplaceExistingObject() throws Exception {
        String initialJson = "{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test\"}";
        String changedJson = "{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test2\"}";
        ContentResponse response = this.writeJsonToCache("key", initialJson, "objectCache");
        ResponseAssertion.assertThat(response).isOk();
        response = this.writeJsonToCache("key", changedJson, "objectCache");
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "objectCache", "key")).header(HttpHeader.ACCEPT, "application/json").send();
        JsonNode jsonNode = new ObjectMapper().readTree(response.getContentAsString());
        AssertJUnit.assertEquals((String)jsonNode.get("name").asText(), (String)"test2");
    }

    private ContentResponse writeJsonToCache(String key, String json, String cacheName) throws Exception {
        return this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), cacheName, key)).content((ContentProvider)new StringContentProvider(json)).header(HttpHeader.CONTENT_TYPE, "application/json").method(HttpMethod.PUT).send();
    }

    @Test
    public void testServerDeserialization() throws Exception {
        Person value = new Person();
        byte[] jsonMarshalled = (byte[])new JsonTranscoder().transcode((Object)value, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON);
        byte[] xmlMarshalled = (byte[])new XMLTranscoder().transcode((Object)value, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_XML);
        byte[] javaMarshalled = new JavaSerializationMarshaller().objectToByteBuffer((Object)value);
        String expectError = "Class '" + value.getClass().getName() + "' blocked by deserialization white list";
        ContentResponse jsonResponse = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "objectCache", "addr2")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{jsonMarshalled})).header(HttpHeader.CONTENT_TYPE, "application/json").method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(jsonResponse).isError();
        ResponseAssertion.assertThat(jsonResponse).containsReturnedText(expectError);
        ContentResponse xmlResponse = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "objectCache", "addr3")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{xmlMarshalled})).header(HttpHeader.CONTENT_TYPE, "application/xml").method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(xmlResponse).isError();
        ResponseAssertion.assertThat(xmlResponse).containsReturnedText(expectError);
        ContentResponse serializationResponse = this.client.newRequest(String.format("http://localhost:%d/rest/v2/caches/%s/%s", this.restServer().getPort(), "objectCache", "addr4")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{javaMarshalled})).header(HttpHeader.CONTENT_TYPE, "application/x-java-serialized-object").method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(serializationResponse).isError();
        ResponseAssertion.assertThat(serializationResponse).containsReturnedText(expectError);
    }
}

