/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.rest.authentication.Authenticator;

public class AuthenticationConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((String)"securityRealm", null, String.class).immutable().build();
    public static final AttributeDefinition<List<String>> MECHANISMS = AttributeDefinition.builder((String)"mechanisms", null, List.class).initializer(ArrayList::new).immutable().build();
    static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition("authentication");
    private final Boolean enabled;
    private final Attribute<String> securityRealm;
    private final Authenticator authenticator;
    private final Attribute<List<String>> mechanisms;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthenticationConfiguration.class, new AttributeDefinition[]{MECHANISMS, SECURITY_REALM});
    }

    AuthenticationConfiguration(AttributeSet attributes, Authenticator authenticator, Boolean enabled) {
        this.attributes = attributes.checkProtection();
        this.enabled = enabled;
        this.mechanisms = attributes.attribute(MECHANISMS);
        this.securityRealm = attributes.attribute(SECURITY_REALM);
        this.authenticator = authenticator;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public List<String> mechanisms() {
        return (List)this.mechanisms.get();
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public String toString() {
        return "AuthenticationConfiguration{enabled=" + this.enabled + ", securityRealm=" + this.securityRealm + ", authenticator=" + this.authenticator + ", attributes=" + this.attributes + '}';
    }
}

