/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.rest.CacheInputStream;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.CacheResource;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.stats.Stats;

public class CacheResourceV2
extends CacheResource {
    private static final int STREAM_BATCH_SIZE = 1000;

    public CacheResourceV2(InvocationHelper invocationHelper) {
        super(invocationHelper);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.PUT, Method.POST).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::putValueToCache).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::getCacheValue).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::deleteCacheValue).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("keys").handleWith(this::streamKeys).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}").withAction("config").handleWith(this::getCacheConfig).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("stats").handleWith(this::getCacheStats).invocation().methods(Method.GET).path("/v2/caches/").handleWith(this::getCacheNames).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").handleWith(this::createCache).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}").handleWith(this::removeCache).invocation().method(Method.HEAD).path("/v2/caches/{cacheName}").handleWith(this::cacheExists).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("clear").handleWith(this::clearEntireCache).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("size").handleWith(this::getSize).invocation().methods(Method.GET, Method.POST).path("/v2/caches/{cacheName}").withAction("search").handleWith(this.queryAction::search).invocation().methods(Method.POST).path("/v2/caches").withAction("toJSON").handleWith(this::convertToJson).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").handleWith(this::getAllDetails).create();
    }

    private CompletionStage<RestResponse> convertToJson(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String contents = restRequest.contents().asString();
        if (contents == null || contents.isEmpty()) {
            responseBuilder.status(HttpResponseStatus.BAD_REQUEST);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        ParserRegistry parserRegistry = this.invocationHelper.getParserRegistry();
        ConfigurationBuilderHolder builderHolder = parserRegistry.parse(contents);
        ConfigurationBuilder builder = (ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().values().iterator().next();
        Configuration configuration = builder.build();
        responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(this.invocationHelper.getJsonWriter().toJSON((ConfigurationInfo)configuration));
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> streamKeys(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        List<String> values = request.parameters().get("batch");
        int batch = values == null || values.isEmpty() ? 1000 : Integer.parseInt(values.iterator().next());
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON, request);
        if (cache == null) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        responseBuilder.entity(new CacheInputStream(cache.keySet().stream(), batch));
        responseBuilder.contentType("application/json");
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> removeCache(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder().status(HttpResponseStatus.NO_CONTENT);
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        AdvancedCache<Object, Object> cache = restCacheManager.getCache(cacheName, request);
        if (cache == null) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return CompletableFuture.supplyAsync(() -> {
            restCacheManager.getCacheManagerAdmin(request).removeCache(cacheName);
            responseBuilder.status(HttpResponseStatus.OK);
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> cacheExists(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = restRequest.variables().get("cacheName");
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletableFuture<RestResponse> createCache(RestRequest request) {
        MediaType sourceType;
        EmbeddedCacheManagerAdmin administration;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder().status(HttpResponseStatus.NO_CONTENT);
        List<String> template = request.parameters().get("template");
        String cacheName = request.variables().get("cacheName");
        EnumSet<CacheContainerAdmin.AdminFlag> adminFlags = request.getAdminFlags();
        EmbeddedCacheManagerAdmin initialAdmin = this.invocationHelper.getRestCacheManager().getCacheManagerAdmin(request);
        EmbeddedCacheManagerAdmin embeddedCacheManagerAdmin = administration = adminFlags == null ? initialAdmin : (EmbeddedCacheManagerAdmin)initialAdmin.withFlags(adminFlags);
        if (template != null && !template.isEmpty()) {
            String templateName = template.iterator().next();
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, templateName);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        ContentSource contents = request.contents();
        byte[] bytes = contents.rawContent();
        if (bytes == null || bytes.length == 0) {
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, (String)null);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        MediaType mediaType = sourceType = request.contentType() == null ? MediaType.APPLICATION_JSON : request.contentType();
        if (sourceType.match(MediaType.APPLICATION_JSON)) {
            this.invocationHelper.getJsonReader().readJson((ConfigurationBuilderInfo)cfgBuilder, StandardConversions.convertTextToObject((Object)bytes, (MediaType)sourceType));
        } else if (sourceType.match(MediaType.APPLICATION_XML)) {
            ConfigurationBuilderHolder builderHolder = this.invocationHelper.getParserRegistry().parse(new String(bytes, StandardCharsets.UTF_8));
            cfgBuilder = builderHolder.getCurrentConfigurationBuilder();
        } else {
            responseBuilder.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        ConfigurationBuilder finalCfgBuilder = cfgBuilder;
        return CompletableFuture.supplyAsync(() -> {
            administration.createCache(cacheName, finalCfgBuilder.build());
            responseBuilder.status(HttpResponseStatus.OK);
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getCacheStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        Stats stats = cache.getAdvancedCache().getStats();
        try {
            byte[] statsResponse = this.invocationHelper.getMapper().writeValueAsBytes((Object)stats);
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(statsResponse).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getAllDetails(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return CompletableFuture.supplyAsync(() -> this.getDetailResponse(responseBuilder, (Cache<?, ?>)cache), this.invocationHelper.getExecutor());
    }

    private RestResponse getDetailResponse(NettyRestResponse.Builder responseBuilder, Cache<?, ?> cache) {
        Stats stats = cache.getAdvancedCache().getStats();
        Configuration configuration = cache.getCacheConfiguration();
        boolean statistics = configuration.jmxStatistics().enabled();
        int size = cache.getAdvancedCache().size();
        DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
        InfinispanQueryStatisticsInfo.IndexStatistics indexStatistics = this.getIndexStatistics(cache);
        boolean rehashInProgress = distributionManager != null && distributionManager.isRehashInProgress();
        boolean indexingInProgress = indexStatistics != null && indexStatistics.getReindexing();
        try {
            CacheFullDetail fullDetail = new CacheFullDetail();
            fullDetail.stats = stats;
            fullDetail.configuration = this.invocationHelper.getJsonWriter().toJSON((ConfigurationInfo)configuration);
            fullDetail.size = size;
            fullDetail.rehashInProgress = rehashInProgress;
            fullDetail.indexingInProgress = indexingInProgress;
            fullDetail.persistent = configuration.persistence().usingStores();
            fullDetail.bounded = configuration.memory().evictionStrategy().isEnabled();
            fullDetail.indexed = configuration.indexing().index().isEnabled();
            fullDetail.hasRemoteBackup = configuration.sites().hasEnabledBackups();
            fullDetail.secured = configuration.security().authorization().enabled();
            fullDetail.transactional = configuration.transaction().transactionMode().isTransactional();
            fullDetail.statistics = statistics;
            byte[] detailsResponse = this.invocationHelper.getMapper().writeValueAsBytes((Object)fullDetail);
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(detailsResponse).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return responseBuilder.build();
    }

    private InfinispanQueryStatisticsInfo.IndexStatistics getIndexStatistics(Cache<?, ?> cache) {
        if (!cache.getCacheConfiguration().indexing().index().isEnabled()) {
            return null;
        }
        return ComponentRegistryUtils.getQueryStatistics((AdvancedCache)cache.getAdvancedCache()).getIndexStatistics();
    }

    private CompletionStage<RestResponse> getCacheConfig(RestRequest request) {
        AdvancedCache<Object, Object> cache;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        MediaType accept = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML);
        responseBuilder.contentType(accept);
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        if ((cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request)) == null) {
            return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.NOT_FOUND.code()).build());
        }
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        String entity = accept.getTypeSubtype().equals("application/xml") ? cacheConfiguration.toXMLString() : this.invocationHelper.getJsonWriter().toJSON((ConfigurationInfo)cacheConfiguration);
        return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.OK).entity(entity).build());
    }

    private CompletionStage<RestResponse> getSize(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        CompletableFuture cacheSize = cache.sizeAsync();
        return cacheSize.thenApply(size -> {
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            try {
                responseBuilder.entity(this.invocationHelper.getMapper().writeValueAsBytes(size));
            }
            catch (JsonProcessingException e) {
                responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            return responseBuilder.build();
        });
    }

    private CompletionStage<RestResponse> getCacheNames(RestRequest request) throws RestResponseException {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        try {
            byte[] bytes = this.invocationHelper.getMapper().writeValueAsBytes(this.invocationHelper.getRestCacheManager().getCacheNames());
            responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(bytes).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    class CacheFullDetail {
        public Stats stats;
        public int size;
        @JsonRawValue
        public String configuration;
        public boolean rehashInProgress;
        public boolean bounded;
        public boolean indexed;
        public boolean persistent;
        public boolean transactional;
        public boolean secured;
        public boolean hasRemoteBackup;
        public boolean indexingInProgress;
        public boolean statistics;

        CacheFullDetail() {
        }
    }
}

