/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.profiling;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.commons.test.Eventually;
import org.infinispan.rest.client.NettyHttpClient;

public class BenchmarkHttpClient {
    private final NettyHttpClient nettyHttpClient;
    private final ExecutorCompletionService executorCompletionService;
    private final ExecutorService executor;

    public BenchmarkHttpClient(RestClientConfiguration configuration, int threads) {
        this.nettyHttpClient = NettyHttpClient.forConfiguration(configuration);
        this.executor = Executors.newFixedThreadPool(threads);
        this.executorCompletionService = new ExecutorCompletionService(this.executor);
    }

    public void performGets(int pertentageOfMisses, int numberOfGets, String existingKey, String nonExistingKey) throws Exception {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < numberOfGets; ++i) {
            String key = ((Random)r).nextInt(100) < pertentageOfMisses ? nonExistingKey : existingKey;
            this.executorCompletionService.submit(() -> {
                DefaultFullHttpRequest getRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/rest/v2/caches/default/" + key);
                count.incrementAndGet();
                this.nettyHttpClient.sendRequest((FullHttpRequest)getRequest).whenComplete((response, e) -> count.decrementAndGet());
                return 1;
            });
        }
        Eventually.eventually(() -> count.get() == 0);
    }

    public void performPuts(int numberOfInserts) {
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < numberOfInserts; ++i) {
            String randomKey = UUID.randomUUID().toString();
            this.executorCompletionService.submit(() -> {
                DefaultFullHttpRequest putValueInCacheRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/rest/v2/caches/default/" + randomKey, Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
                count.incrementAndGet();
                this.nettyHttpClient.sendRequest((FullHttpRequest)putValueInCacheRequest).whenComplete((response, e) -> count.decrementAndGet());
                return 1;
            });
        }
        Eventually.eventually(() -> count.get() == 0);
    }

    public void stop() {
        this.nettyHttpClient.stop();
        this.executor.shutdownNow();
    }
}

