/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.Util;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.ResponseWriter;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.util.concurrent.CompletableFutures;

public abstract class BaseHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    final RestAccessLoggingHandler restAccessLoggingHandler = new RestAccessLoggingHandler();

    BaseHttpRequestHandler() {
        super(false);
    }

    void handleError(ChannelHandlerContext ctx, FullHttpRequest request, Throwable throwable) {
        NettyRestResponse errorResponse;
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        if (cause instanceof RestResponseException) {
            RestResponseException responseException = (RestResponseException)throwable;
            this.getLogger().errorWhileResponding(responseException);
            errorResponse = new NettyRestResponse.Builder().status(responseException.getStatus()).entity(responseException.getText()).build();
        } else if (cause instanceof SecurityException) {
            errorResponse = new NettyRestResponse.Builder().status(HttpResponseStatus.FORBIDDEN).entity(cause.getMessage()).build();
        } else if (cause instanceof CacheConfigurationException || cause instanceof IllegalArgumentException) {
            errorResponse = new NettyRestResponse.Builder().status(HttpResponseStatus.BAD_REQUEST).entity(cause.getMessage()).build();
        } else {
            Throwable rootCause = Util.getRootCause((Throwable)throwable);
            errorResponse = new NettyRestResponse.Builder().status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(rootCause.getMessage()).build();
        }
        this.sendResponse(ctx, request, errorResponse);
    }

    void sendResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response) {
        ctx.executor().execute(() -> ResponseWriter.forContent(response.getEntity()).writeResponse(ctx, request, response));
    }

    protected abstract Log getLogger();
}

