/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import org.infinispan.rest.CorsHandler;
import org.infinispan.rest.CorsUtil;
import org.infinispan.rest.Http11RequestHandler;
import org.infinispan.rest.RestRequestHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;

@ChannelHandler.Sharable
public class ALPNHandler
extends ApplicationProtocolNegotiationHandler {
    private static final int CROSS_ORIGIN_ALT_PORT = 9000;
    protected final RestServer restServer;

    public ALPNHandler(RestServer restServer) {
        super("http/1.1");
        this.restServer = restServer;
    }

    public void configurePipeline(ChannelHandlerContext ctx, String protocol) {
        this.configurePipeline(ctx.pipeline(), protocol);
    }

    public void configurePipeline(ChannelPipeline pipeline, String protocol) {
        if ("h2".equals(protocol)) {
            this.configureHttp2(pipeline);
            return;
        }
        if ("http/1.1".equals(protocol)) {
            this.configureHttp1(pipeline);
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    protected void configureHttp2(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{this.getHttp11To2ConnectionHandler()});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast("rest-handler-http2", (ChannelHandler)new RestRequestHandler(this.restServer));
    }

    protected void configureHttp1(ChannelPipeline pipeline) {
        Http2MultiplexCodec multiplexCodec = Http2MultiplexCodecBuilder.forServer((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline p = channel.pipeline();
                p.addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
                p.addLast(new ChannelHandler[]{new HttpObjectAggregator(ALPNHandler.this.maxContentLength())});
                p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                p.addLast(new ChannelHandler[]{new RestRequestHandler(ALPNHandler.this.restServer)});
            }
        }).initialSettings(Http2Settings.defaultSettings()).build();
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(multiplexCodec);
            }
            return null;
        };
        HttpServerCodec httpCodec = new HttpServerCodec(4096, 8192, this.maxContentLength());
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpCodec, upgradeCodecFactory, this.maxContentLength());
        CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(httpCodec, upgradeHandler, (ChannelHandler)multiplexCodec);
        pipeline.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
        pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor(((RestServerConfiguration)this.restServer.getConfiguration()).getCompressionLevel())});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength())});
        ArrayList<CorsConfig> corsRules = new ArrayList<CorsConfig>();
        corsRules.addAll(CorsUtil.enableAllForSystemConfig());
        corsRules.addAll(CorsUtil.enableAllForLocalHost(this.restServer.getPort(), 9000));
        corsRules.addAll(((RestServerConfiguration)this.restServer.getConfiguration()).getCorsRules());
        pipeline.addLast(new ChannelHandler[]{new CorsHandler(corsRules, true)});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new Http11RequestHandler(this.restServer)});
    }

    protected int maxContentLength() {
        return ((RestServerConfiguration)this.restServer.getConfiguration()).maxContentLength() + 4096 + 8192;
    }

    private HttpToHttp2ConnectionHandler getHttp11To2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        InboundHttp2ToHttpAdapter listener = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).propagateSettings(true).validateHttpHeaders(false).maxContentLength(this.maxContentLength()).build();
        return new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)listener).connection((Http2Connection)connection).build();
    }

    public ChannelHandler getHttp1Handler() {
        return new Http11RequestHandler(this.restServer);
    }

    public ApplicationProtocolConfig getAlpnConfiguration() {
        if (((RestServerConfiguration)this.restServer.getConfiguration()).ssl().enabled()) {
            return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
        }
        return null;
    }
}

