/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.ResponseWriter;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.util.concurrent.CompletableFutures;

public abstract class BaseHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    final RestAccessLoggingHandler restAccessLoggingHandler = new RestAccessLoggingHandler();

    BaseHttpRequestHandler() {
        super(false);
    }

    void handleError(ChannelHandlerContext ctx, FullHttpRequest request, Throwable throwable) {
        NettyRestResponse errorResponse;
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        if (cause instanceof RestResponseException) {
            RestResponseException responseException = (RestResponseException)throwable;
            this.getLogger().errorWhileResponding(responseException);
            errorResponse = new NettyRestResponse.Builder().status(responseException.getStatus()).entity(responseException.getText()).build();
        } else {
            errorResponse = cause instanceof SecurityException ? new NettyRestResponse.Builder().status(HttpResponseStatus.FORBIDDEN).entity(cause.getMessage()).build() : (cause instanceof CacheConfigurationException ? new NettyRestResponse.Builder().status(HttpResponseStatus.BAD_REQUEST).entity(cause.getMessage()).build() : new NettyRestResponse.Builder().status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(cause.getMessage()).build());
        }
        this.sendResponse(ctx, request, errorResponse);
    }

    void sendResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response) {
        ctx.executor().execute(() -> {
            this.addCorrelatedHeaders(request, response.getResponse());
            ResponseWriter.forContent(response.getEntity()).writeResponse(ctx, request, response, this.checkKeepAlive());
        });
    }

    private void addCorrelatedHeaders(FullHttpRequest request, HttpResponse response) {
        String streamId = request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId != null) {
            response.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpVersion httpVersion = response.protocolVersion();
        if ((httpVersion == HttpVersion.HTTP_1_1 || httpVersion == HttpVersion.HTTP_1_0) && isKeepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
    }

    protected boolean checkKeepAlive() {
        return false;
    }

    protected abstract Log getLogger();
}

