/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.JsonErrorResponseEntity;
import org.infinispan.util.logging.LogFactory;

class ResourceUtil {
    private static final Log logger = (Log)LogFactory.getLog(ResourceUtil.class, Log.class);

    ResourceUtil() {
    }

    static CompletableFuture<RestResponse> notFoundResponseFuture() {
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.NOT_FOUND).build());
    }

    static RestResponse asJsonResponse(Object o, InvocationHelper invocationHelper) {
        return ResourceUtil.addEntityAsJson(o, new NettyRestResponse.Builder(), invocationHelper).build();
    }

    static CompletableFuture<RestResponse> asJsonResponseFuture(Object o, InvocationHelper invocationHelper) {
        return CompletableFuture.completedFuture(ResourceUtil.asJsonResponse(o, invocationHelper));
    }

    static CompletableFuture<RestResponse> asJsonResponseFuture(Object o, NettyRestResponse.Builder responseBuilder, InvocationHelper invocationHelper) {
        NettyRestResponse response = ResourceUtil.addEntityAsJson(o, responseBuilder, invocationHelper).build();
        return CompletableFuture.completedFuture(response);
    }

    static NettyRestResponse.Builder addEntityAsJson(Object o, NettyRestResponse.Builder responseBuilder, InvocationHelper invocationHelper) {
        responseBuilder.contentType(MediaType.APPLICATION_JSON);
        ObjectMapper mapper = invocationHelper.getMapper();
        try {
            byte[] bytes = mapper.writeValueAsBytes(o);
            return responseBuilder.entity(bytes).status(HttpResponseStatus.OK);
        }
        catch (JsonProcessingException e) {
            logger.error((Object)e);
            Object entity = ResourceUtil.createJsonErrorResponse(mapper, e);
            return responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(entity);
        }
    }

    private static Object createJsonErrorResponse(ObjectMapper mapper, JsonProcessingException e) {
        try {
            return mapper.writeValueAsBytes((Object)new JsonErrorResponseEntity("Unable to convert response object to json", e.getMessage()));
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)jpe);
            return jpe.getMessage();
        }
    }
}

