/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;

public class ClusterResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;

    public ClusterResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET, Method.POST).path("/v2/cluster").withAction("stop").handleWith(this::stop).create();
    }

    private CompletionStage<RestResponse> stop(RestRequest restRequest) {
        HttpResponseStatus status;
        List<String> servers = restRequest.parameters().get("server");
        HttpResponseStatus httpResponseStatus = status = restRequest.method().equals((Object)Method.POST) ? HttpResponseStatus.NO_CONTENT : HttpResponseStatus.OK;
        if (servers != null && !servers.isEmpty()) {
            this.invocationHelper.getServer().serverStop(servers);
        } else {
            this.invocationHelper.getServer().clusterStop();
        }
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(status).build());
    }
}

