/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;

public final class LoggingResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;

    public LoggingResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        SimpleModule module = new SimpleModule();
        module.addSerializer(LoggerConfig.class, (JsonSerializer)new Log4j2LoggerConfigSerializer());
        module.addSerializer(Appender.class, (JsonSerializer)new Log4j2AppenderSerializer());
        this.invocationHelper.getMapper().registerModule((Module)module);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/logging/loggers").handleWith(this::listLoggers).invocation().methods(Method.GET).path("/v2/logging/appenders").handleWith(this::listAppenders).invocation().methods(Method.DELETE).path("/v2/logging/loggers/{loggerName}").handleWith(this::deleteLogger).invocation().methods(Method.PUT).path("/v2/logging/loggers/{loggerName}").handleWith(this::setLogger).invocation().methods(Method.PUT).path("/v2/logging/loggers").handleWith(this::setLogger).create();
    }

    private CompletionStage<RestResponse> setLogger(RestRequest request) {
        TaskManager taskManager = this.invocationHelper.getServer().getTaskManager();
        String loggerName = request.variables().get("loggerName");
        String level = request.getParameter("level");
        List<String> appenders = request.parameters().get("appender");
        if (level == null && appenders == null) {
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.BAD_REQUEST).build());
        }
        return taskManager.runTask("@@logging@set", new TaskContext().addOptionalParameter("loggerName", (Object)loggerName).addOptionalParameter("level", (Object)level).addOptionalParameter("appenders", appenders).subject(request.getSubject())).handle((? super T o, Throwable t) -> this.handle((Throwable)t));
    }

    private CompletionStage<RestResponse> deleteLogger(RestRequest request) {
        TaskManager taskManager = this.invocationHelper.getServer().getTaskManager();
        String loggerName = request.variables().get("loggerName");
        return taskManager.runTask("@@logging@remove", new TaskContext().addParameter("loggerName", (Object)loggerName).subject(request.getSubject())).handle((? super T o, Throwable t) -> this.handle((Throwable)t));
    }

    private CompletionStage<RestResponse> listLoggers(RestRequest request) {
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        return ResourceUtil.asJsonResponseFuture(logContext.getConfiguration().getLoggers().values(), this.invocationHelper);
    }

    private CompletionStage<RestResponse> listAppenders(RestRequest request) {
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        return ResourceUtil.asJsonResponseFuture(logContext.getConfiguration().getAppenders(), this.invocationHelper);
    }

    private NettyRestResponse handle(Throwable t) {
        NettyRestResponse.Builder response = new NettyRestResponse.Builder();
        if (t == null) {
            response.status(HttpResponseStatus.NO_CONTENT);
        } else {
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof IllegalStateException) {
                response.status(HttpResponseStatus.CONFLICT).entity(t.getMessage());
            } else if (t instanceof IllegalArgumentException) {
                response.status(HttpResponseStatus.BAD_REQUEST).entity(t.getMessage());
            } else if (t instanceof NoSuchElementException) {
                response.status(HttpResponseStatus.NOT_FOUND).entity(t.getMessage());
            } else if (t instanceof SecurityException) {
                response.status(HttpResponseStatus.FORBIDDEN).entity(t.getMessage());
            } else {
                response.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(t.getMessage());
            }
        }
        return response.build();
    }

    public static class Log4j2AppenderSerializer
    extends StdSerializer<Appender> {
        public Log4j2AppenderSerializer() {
            this(null);
        }

        public Log4j2AppenderSerializer(Class<Appender> t) {
            super(t);
        }

        public void serialize(Appender appender, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", appender.getName());
            json.writeEndObject();
        }
    }

    public static class Log4j2LoggerConfigSerializer
    extends StdSerializer<LoggerConfig> {
        public Log4j2LoggerConfigSerializer() {
            this(null);
        }

        public Log4j2LoggerConfigSerializer(Class<LoggerConfig> t) {
            super(t);
        }

        public void serialize(LoggerConfig logger2, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", logger2.getName());
            json.writeStringField("level", logger2.getLevel().name());
            json.writeArrayFieldStart("appenders");
            for (String appender : logger2.getAppenders().keySet()) {
                json.writeString(appender);
            }
            json.writeEndArray();
            json.writeEndObject();
        }
    }
}

