/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.JVMMemoryInfoInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.security.Security;
import org.infinispan.server.core.CacheIgnoreManager;
import org.infinispan.server.core.ServerManagement;

public class ServerResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private static final ServerInfo SERVER_INFO = new ServerInfo();

    public ServerResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        SimpleModule module = new SimpleModule();
        module.addSerializer(ServerInfo.class, (JsonSerializer)new ServerInfoSerializer());
        this.invocationHelper.getMapper().registerModule((Module)module);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/server/").handleWith(this::info).invocation().methods(Method.GET).path("/v2/server/config").handleWith(this::config).invocation().methods(Method.GET).path("/v2/server/env").handleWith(this::env).invocation().methods(Method.GET).path("/v2/server/memory").handleWith(this::memory).invocation().methods(Method.GET, Method.POST).path("/v2/server/").withAction("stop").handleWith(this::stop).invocation().methods(Method.GET).path("/v2/server/threads").handleWith(this::threads).invocation().methods(Method.GET).path("/v2/server/report").handleWith(this::report).invocation().methods(Method.GET).path("/v2/server/cache-managers").handleWith(this::cacheManagers).invocation().methods(Method.GET).path("/v2/server/ignored-caches/{cache-manager}").handleWith(this::listIgnored).invocation().methods(Method.POST, Method.DELETE).path("/v2/server/ignored-caches/{cache-manager}/{cache}").handleWith(this::doIgnoreOp).create();
    }

    private CompletionStage<RestResponse> doIgnoreOp(RestRequest restRequest) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder().status(HttpResponseStatus.NO_CONTENT);
        boolean add = restRequest.method().equals((Object)Method.POST);
        String cacheManagerName = restRequest.variables().get("cache-manager");
        DefaultCacheManager cacheManager = this.invocationHelper.getServer().getCacheManager(cacheManagerName);
        if (cacheManager == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        String cacheName = restRequest.variables().get("cache");
        if (!cacheManager.getCacheNames().contains(cacheName)) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        ServerManagement server = this.invocationHelper.getServer();
        CacheIgnoreManager ignoreManager = server.getIgnoreManager(cacheManagerName);
        return (CompletionStage)Security.doAs((Subject)restRequest.getSubject(), () -> add ? ignoreManager.ignoreCache(cacheName).thenApply(r -> builder.build()) : ignoreManager.unignoreCache(cacheName).thenApply(r -> builder.build()));
    }

    private CompletionStage<RestResponse> listIgnored(RestRequest restRequest) {
        String cacheManagerName = restRequest.variables().get("cache-manager");
        DefaultCacheManager cacheManager = this.invocationHelper.getServer().getCacheManager(cacheManagerName);
        if (cacheManager == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        CacheIgnoreManager ignoreManager = this.invocationHelper.getServer().getIgnoreManager(cacheManagerName);
        Set ignored = ignoreManager.getIgnoredCaches();
        return ResourceUtil.asJsonResponseFuture(ignored, this.invocationHelper);
    }

    private CompletionStage<RestResponse> cacheManagers(RestRequest restRequest) {
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.getServer().cacheManagerNames(), this.invocationHelper);
    }

    private CompletionStage<RestResponse> memory(RestRequest restRequest) {
        return ResourceUtil.asJsonResponseFuture(new JVMMemoryInfoInfo(), this.invocationHelper);
    }

    private CompletionStage<RestResponse> env(RestRequest restRequest) {
        return ResourceUtil.asJsonResponseFuture(System.getProperties(), this.invocationHelper);
    }

    private CompletionStage<RestResponse> info(RestRequest restRequest) {
        return ResourceUtil.asJsonResponseFuture(SERVER_INFO, this.invocationHelper);
    }

    private CompletionStage<RestResponse> threads(RestRequest restRequest) {
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().contentType(MediaType.TEXT_PLAIN).entity(Util.threadDump()).build());
    }

    private CompletionStage<RestResponse> report(RestRequest restRequest) {
        ServerManagement server = this.invocationHelper.getServer();
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        return (CompletionStage)Security.doAs((Subject)restRequest.getSubject(), () -> server.getServerReport().handle((path, t) -> {
            if (t != null) {
                return responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).build();
            }
            return responseBuilder.contentType(MediaType.fromString((String)"application/gzip")).header("Content-Disposition", String.format("attachment; filename=\"%s-%s-%3$tY%3$tm%3$td%3$tH%3$tM%3$tS-report.tar.gz\"", Version.getBrandName().toLowerCase().replaceAll("\\s", "-"), this.invocationHelper.getRestCacheManager().getNodeName(), Calendar.getInstance())).entity(path.toFile()).build();
        }));
    }

    private CompletionStage<RestResponse> stop(RestRequest restRequest) {
        Security.doAs((Subject)restRequest.getSubject(), () -> {
            this.invocationHelper.getServer().serverStop(Collections.emptyList());
            return null;
        });
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(restRequest.method().equals((Object)Method.POST) ? HttpResponseStatus.NO_CONTENT : HttpResponseStatus.OK).build());
    }

    private CompletionStage<RestResponse> config(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String json = this.invocationHelper.getJsonWriter().toJSON(this.invocationHelper.getServer().getConfiguration());
        responseBuilder.entity(json).contentType(MediaType.APPLICATION_JSON);
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    static class ServerInfoSerializer
    extends StdSerializer<ServerInfo> {
        public ServerInfoSerializer() {
            this(null);
        }

        public ServerInfoSerializer(Class<ServerInfo> t) {
            super(t);
        }

        public void serialize(ServerInfo serverInfo, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
            json.writeStartObject();
            json.writeStringField("version", serverInfo.getVersion());
            json.writeEndObject();
        }
    }

    static class ServerInfo {
        final String version = Version.printVersion();

        ServerInfo() {
        }

        public String getVersion() {
            return this.version;
        }
    }
}

