/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.rxjava3.core.Flowable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.xml.stream.XMLStreamException;
import org.hibernate.search.util.common.function.TriFunction;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.health.CacheHealth;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.Health;
import org.infinispan.health.HealthStatus;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.BackupManagerResource;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.security.Security;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.CacheIgnoreManager;
import org.infinispan.util.function.TriConsumer;

public class CacheManagerResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final EmbeddedCacheManager cacheManager;
    private final InternalCacheRegistry internalCacheRegistry;
    private final JsonWriter jsonWriter = new JsonWriter();
    private final ParserRegistry parserRegistry = new ParserRegistry();
    private final String cacheManagerName;
    private final RestCacheManager<Object> restCacheManager;
    private final CacheIgnoreManager cacheIgnoreManager;

    public CacheManagerResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        this.cacheManager = invocationHelper.getRestCacheManager().getInstance();
        this.restCacheManager = invocationHelper.getRestCacheManager();
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(this.cacheManager);
        this.cacheManagerName = globalConfiguration.cacheManagerName();
        GlobalComponentRegistry globalComponentRegistry = SecurityActions.getGlobalComponentRegistry(this.cacheManager);
        this.internalCacheRegistry = (InternalCacheRegistry)globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        this.cacheIgnoreManager = (CacheIgnoreManager)globalComponentRegistry.getComponent(CacheIgnoreManager.class);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET, Method.HEAD).path("/v2/cache-managers/{name}/health").handleWith(this::getHealth).invocation().methods(Method.GET, Method.HEAD).anonymous(true).path("/v2/cache-managers/{name}/health/status").handleWith(this::getHealthStatus).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/cache-configs").handleWith(this::getAllCachesConfiguration).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/cache-configs/templates").handleWith(this::getAllCachesConfigurationTemplates).invocation().methods(Method.POST).path("/v2/cache-managers/{name}/config").withAction("toJSON").handleWith(this::convertToJson).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/config").handleWith(this::getConfig).invocation().methods(Method.GET).path("/v2/cache-managers/{name}").handleWith(this::getInfo).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/stats").handleWith(this::getStats).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/caches").handleWith(this::getCaches).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/backups").handleWith(this::getAllBackupNames).invocation().methods(Method.DELETE, Method.GET, Method.HEAD, Method.POST).path("/v2/cache-managers/{name}/backups/{backupName}").handleWith(this::backup).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/restores").handleWith(this::getAllRestoreNames).invocation().methods(Method.DELETE, Method.HEAD, Method.POST).path("/v2/cache-managers/{name}/restores/{restoreName}").handleWith(this::restore).create();
    }

    private CompletionStage<RestResponse> getInfo(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return ResourceUtil.asJsonResponseFuture(this.cacheManager.getCacheManagerInfo().toJson(), responseBuilder);
    }

    private CompletionStage<RestResponse> getConfig(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager embeddedCacheManager = this.cacheManager.withSubject(request.getSubject());
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(embeddedCacheManager);
        MediaType format = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.parserRegistry.serialize((OutputStream)baos, globalConfiguration, Collections.emptyMap());
            if (format.match(MediaType.APPLICATION_XML)) {
                responseBuilder.contentType(MediaType.APPLICATION_XML);
                responseBuilder.entity(baos.toByteArray());
            } else {
                responseBuilder.contentType(MediaType.APPLICATION_JSON);
                responseBuilder.entity(this.jsonWriter.toJSON((ConfigurationInfo)globalConfiguration));
            }
        }
        catch (XMLStreamException e) {
            responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return ResourceUtil.asJsonResponseFuture(this.cacheManager.getStats().toJson(), responseBuilder);
    }

    private CompletionStage<RestResponse> getHealth(RestRequest restRequest) {
        return this.getHealth(restRequest, false);
    }

    private CompletionStage<RestResponse> getHealthStatus(RestRequest restRequest) {
        return this.getHealth(restRequest, true);
    }

    private CompletionStage<RestResponse> getHealth(RestRequest restRequest, boolean anon) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(restRequest);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        if (restRequest.method() == Method.HEAD) {
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.OK).build());
        }
        Health health = this.cacheManager.withSubject(restRequest.getSubject()).getHealth();
        HealthInfo healthInfo = new HealthInfo(health.getClusterHealth(), health.getCacheHealth());
        if (anon) {
            responseBuilder.contentType(MediaType.TEXT_PLAIN).entity(Security.doAs((Subject)restRequest.getSubject(), () -> healthInfo.clusterHealth.getHealthStatus().toString())).status(HttpResponseStatus.OK);
        } else {
            ResourceUtil.addEntityAsJson(healthInfo.toJson(), responseBuilder);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getCaches(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager subjectCacheManager = this.cacheManager.withSubject(request.getSubject());
        HashMap<String, HealthStatus> cachesHealth = new HashMap<String, HealthStatus>();
        HashSet cacheNames = new HashSet(subjectCacheManager.getCacheNames());
        cacheNames.removeAll(this.internalCacheRegistry.getInternalCacheNames());
        Set ignoredCaches = this.cacheIgnoreManager.getIgnoredCaches();
        for (CacheHealth ch : SecurityActions.getHealth(subjectCacheManager).getCacheHealth(cacheNames)) {
            cachesHealth.put(ch.getCacheName(), ch.getStatus());
        }
        return Flowable.fromIterable(cachesHealth.entrySet()).map(chHealth -> {
            HealthStatus cacheHealth;
            String cacheName;
            CacheInfo cacheInfo = new CacheInfo();
            cacheInfo.name = cacheName = (String)chHealth.getKey();
            cacheInfo.health = cacheHealth = (HealthStatus)cachesHealth.get(cacheName);
            Configuration cacheConfiguration = SecurityActions.getCacheConfigurationFromManager(subjectCacheManager, cacheName);
            cacheInfo.type = cacheConfiguration.clustering().cacheMode().toCacheType();
            cacheInfo.simpleCache = cacheConfiguration.simpleCache();
            cacheInfo.transactional = cacheConfiguration.transaction().transactionMode().isTransactional();
            cacheInfo.persistent = cacheConfiguration.persistence().usingStores();
            cacheInfo.bounded = cacheConfiguration.expiration().maxIdle() != -1L || cacheConfiguration.expiration().lifespan() != -1L;
            cacheInfo.secured = cacheConfiguration.security().authorization().enabled();
            cacheInfo.indexed = cacheConfiguration.indexing().enabled();
            cacheInfo.hasRemoteBackup = cacheConfiguration.sites().hasEnabledBackups();
            if (ignoredCaches.contains(cacheName)) {
                cacheInfo.status = "IGNORED";
            } else if (cacheHealth != HealthStatus.FAILED) {
                AdvancedCache<Object, Object> cache = this.restCacheManager.getCache(cacheName, request);
                cacheInfo.status = cache.getStatus().toString();
            } else {
                cacheInfo.status = ComponentStatus.FAILED.toString();
            }
            return cacheInfo;
        }).collectInto(new HashSet(), Set::add).map(cacheInfos -> {
            List sortedCacheInfos = cacheInfos.stream().sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
            return ResourceUtil.addEntityAsJson(Json.make(sortedCacheInfos), responseBuilder).build();
        }).toCompletionStage();
    }

    private CompletionStage<RestResponse> getAllCachesConfiguration(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager subjectCacheManager = this.cacheManager.withSubject(request.getSubject());
        Set cacheConfigurationNames = subjectCacheManager.getCacheConfigurationNames();
        List configurations = cacheConfigurationNames.stream().filter(n -> !this.internalCacheRegistry.isInternalCache(n)).distinct().map(n -> {
            Configuration cacheConfiguration = SecurityActions.getCacheConfigurationFromManager(subjectCacheManager, n);
            String json = this.jsonWriter.toJSON((ConfigurationInfo)cacheConfiguration);
            return new NamedCacheConfiguration((String)n, json);
        }).sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
        return ResourceUtil.asJsonResponseFuture(Json.make(configurations), responseBuilder);
    }

    private CompletionStage<RestResponse> getAllCachesConfigurationTemplates(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager subjectCacheManager = this.cacheManager.withSubject(request.getSubject());
        Set cacheConfigurationNames = subjectCacheManager.getCacheConfigurationNames();
        List configurations = cacheConfigurationNames.stream().filter(n -> !this.internalCacheRegistry.isInternalCache(n)).filter(n -> SecurityActions.getCacheConfigurationFromManager(subjectCacheManager, n).isTemplate()).distinct().map(n -> {
            Configuration config = SecurityActions.getCacheConfigurationFromManager(subjectCacheManager, n);
            return new NamedCacheConfiguration((String)n, this.jsonWriter.toJSON((ConfigurationInfo)config));
        }).sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
        return ResourceUtil.asJsonResponseFuture(Json.make(configurations), responseBuilder);
    }

    private CompletionStage<RestResponse> getAllBackupNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = backupManager.getBackupNames();
        return ResourceUtil.asJsonResponseFuture(Json.make((Object)names));
    }

    private CompletionStage<RestResponse> backup(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        return BackupManagerResource.handleBackupRequest(request, backupManager, (TriConsumer<String, Path, Json>)((TriConsumer)(name, workingDir, json) -> {
            BackupManager.Resources resources = BackupManagerResource.getResources(json);
            Map<String, BackupManager.Resources> backupParams = Collections.singletonMap(this.cacheManagerName, resources);
            backupManager.create(name, workingDir, backupParams);
        }));
    }

    private CompletionStage<RestResponse> getAllRestoreNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = backupManager.getRestoreNames();
        return ResourceUtil.asJsonResponseFuture(Json.make((Object)names));
    }

    private CompletionStage<RestResponse> restore(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        return BackupManagerResource.handleRestoreRequest(request, backupManager, (TriFunction<String, Path, Json, CompletionStage<Void>>)((TriFunction)(name, path, json) -> {
            BackupManager.Resources resources = BackupManagerResource.getResources(json);
            Map<String, BackupManager.Resources> restoreParams = Collections.singletonMap(this.cacheManagerName, resources);
            return backupManager.restore(name, path, restoreParams);
        }));
    }

    private CompletionStage<RestResponse> convertToJson(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = this.checkCacheManager(restRequest);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        ContentSource contents = restRequest.contents();
        ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(new String(contents.rawContent(), StandardCharsets.UTF_8));
        ConfigurationBuilder builder = (ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().values().iterator().next();
        Configuration configuration = builder.build();
        responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(this.jsonWriter.toJSON((ConfigurationInfo)configuration));
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private NettyRestResponse.Builder checkCacheManager(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String name = request.variables().get("name");
        if (!name.equals(this.cacheManagerName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
        }
        return responseBuilder;
    }

    static class CacheInfo
    implements JsonSerialization {
        public String status;
        public String name;
        public String type;
        public boolean simpleCache;
        public boolean transactional;
        public boolean persistent;
        public boolean bounded;
        public boolean indexed;
        public boolean secured;
        public boolean hasRemoteBackup;
        public HealthStatus health;

        CacheInfo() {
        }

        public Json toJson() {
            return Json.object().set("status", (Object)this.status).set("name", (Object)this.name).set("type", (Object)this.type).set("simple_cache", (Object)this.simpleCache).set("transactional", (Object)this.transactional).set("persistent", (Object)this.persistent).set("bounded", (Object)this.bounded).set("secured", (Object)this.secured).set("indexed", (Object)this.indexed).set("has_remote_backup", (Object)this.hasRemoteBackup).set("health", (Object)this.health);
        }
    }

    static class NamedCacheConfiguration
    implements JsonSerialization {
        String name;
        String configuration;

        NamedCacheConfiguration(String name, String configuration) {
            this.name = name;
            this.configuration = configuration;
        }

        public Json toJson() {
            return Json.object().set("name", (Object)this.name).set("configuration", Json.factory().raw(this.configuration));
        }
    }

    static class HealthInfo
    implements JsonSerialization {
        private final ClusterHealth clusterHealth;
        private final List<CacheHealth> cacheHealth;

        HealthInfo(ClusterHealth clusterHealth, List<CacheHealth> cacheHealth) {
            this.clusterHealth = clusterHealth;
            this.cacheHealth = cacheHealth;
        }

        public Json toJson() {
            return Json.object().set("cluster_health", this.clusterHealth.toJson()).set("cache_health", Json.make(this.cacheHealth));
        }
    }
}

