/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.query.Indexer;
import org.infinispan.query.Search;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.query.impl.massindex.MassIndexerAlreadyStartedException;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.util.logging.LogFactory;

public class SearchAdminResource
implements ResourceHandler {
    private static final Log LOG = (Log)LogFactory.getLog(SearchAdminResource.class, Log.class);
    private final InvocationHelper invocationHelper;

    public SearchAdminResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/indexes").withAction("mass-index").handleWith(this::reindex).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/indexes").withAction("clear").handleWith(this::clearIndexes).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/indexes/stats").deprecated().handleWith(this::indexStats).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/query/stats").deprecated().handleWith(this::queryStats).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/query/stats").deprecated().withAction("clear").handleWith(this::clearStats).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/stats").handleWith(this::searchStats).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/stats").withAction("clear").handleWith(this::clearSearchStats).create();
    }

    private CompletionStage<RestResponse> searchStats(RestRequest restRequest) {
        String scopeParam;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = restRequest.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, restRequest);
        if (cache == null) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND.code());
            return null;
        }
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        if (!cacheConfiguration.statistics().enabled()) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND.code()).build();
        }
        if ((scopeParam = restRequest.getParameter("scope")) != null && scopeParam.equalsIgnoreCase("cluster")) {
            CompletionStage stats = Search.getClusteredSearchStatistics(cache);
            return stats.thenApply(s -> ResourceUtil.asJsonResponse(this.makeJson((SearchStatistics)s)));
        }
        SearchStatistics searchStatistics = Search.getSearchStatistics(cache);
        return ResourceUtil.asJsonResponseFuture(this.makeJson(searchStatistics));
    }

    private CompletionStage<RestResponse> clearSearchStats(RestRequest restRequest) {
        String scopeParam;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = restRequest.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, restRequest);
        if (cache == null) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND.code());
            return null;
        }
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        if (!cacheConfiguration.statistics().enabled()) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND.code()).build();
        }
        if ((scopeParam = restRequest.getParameter("scope")) != null && scopeParam.equalsIgnoreCase("cluster")) {
            throw new CacheException("NotImplemented");
        }
        SearchStatistics searchStatistics = Search.getSearchStatistics(cache);
        searchStatistics.getQueryStatistics().clear();
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private Json makeJson(SearchStatistics searchStatistics) {
        return Json.object().set("query", Json.make((Object)searchStatistics.getQueryStatistics())).set("index", Json.make((Object)searchStatistics.getIndexStatistics()));
    }

    private CompletionStage<RestResponse> reindex(RestRequest request) {
        return this.runIndexer(request, Indexer::run, true);
    }

    private CompletionStage<RestResponse> clearIndexes(RestRequest request) {
        return this.runIndexer(request, Indexer::remove, false);
    }

    private CompletionStage<RestResponse> indexStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        InfinispanQueryStatisticsInfo searchStats = this.lookupQueryStatistics(request, responseBuilder);
        if (searchStats == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return ResourceUtil.asJsonResponseFuture(searchStats.getLegacyIndexStatistics(), responseBuilder);
    }

    private CompletionStage<RestResponse> queryStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        InfinispanQueryStatisticsInfo searchStats = this.lookupQueryStatistics(request, responseBuilder);
        if (searchStats == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return ResourceUtil.asJsonResponseFuture(searchStats.getLegacyQueryStatistics(), responseBuilder);
    }

    private CompletionStage<RestResponse> clearStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        InfinispanQueryStatisticsInfo queryStatistics = this.lookupQueryStatistics(request, responseBuilder);
        if (queryStatistics == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        queryStatistics.clear();
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> runIndexer(RestRequest request, Function<Indexer, CompletionStage<Void>> op, boolean supportAsync) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        List<String> mode = request.parameters().get("mode");
        boolean asyncParams = mode != null && !mode.isEmpty() && mode.iterator().next().equalsIgnoreCase("async");
        boolean async = asyncParams && supportAsync;
        AdvancedCache<?, ?> cache = this.lookupIndexedCache(request, responseBuilder);
        int status = responseBuilder.getStatus();
        if (status < 200 || status > 299) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        Indexer indexer = ComponentRegistryUtils.getIndexer(cache);
        if (async) {
            try {
                LOG.asyncMassIndexerStarted();
                op.apply(indexer).whenComplete((v, e) -> {
                    if (e == null) {
                        LOG.asyncMassIndexerSuccess();
                    } else {
                        LOG.errorExecutingMassIndexer(e.getCause());
                    }
                });
            }
            catch (Exception e2) {
                responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).entity("Error executing the MassIndexer " + e2.getCause());
            }
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return op.apply(indexer).exceptionally(e -> {
            if (e instanceof MassIndexerAlreadyStartedException) {
                responseBuilder.status(HttpResponseStatus.BAD_REQUEST.code()).entity("MassIndexer already started");
            } else {
                responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).entity("Error executing the MassIndexer " + e.getCause());
            }
            return null;
        }).thenApply(v -> responseBuilder.build());
    }

    private AdvancedCache<?, ?> lookupIndexedCache(RestRequest request, NettyRestResponse.Builder builder) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            builder.status(HttpResponseStatus.NOT_FOUND.code());
            return null;
        }
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        if (!cacheConfiguration.indexing().enabled()) {
            builder.entity("cache is not indexed").status(HttpResponseStatus.BAD_REQUEST.code()).build();
        }
        return cache;
    }

    private AdvancedCache<?, ?> lookupCacheWithStats(RestRequest request, NettyRestResponse.Builder builder) {
        Configuration cacheConfiguration;
        AdvancedCache<?, ?> cache = this.lookupIndexedCache(request, builder);
        if (cache != null && !(cacheConfiguration = cache.getCacheConfiguration()).statistics().enabled()) {
            builder.entity("statistics not enabled").status(HttpResponseStatus.BAD_REQUEST.code());
        }
        return cache;
    }

    private InfinispanQueryStatisticsInfo lookupQueryStatistics(RestRequest request, NettyRestResponse.Builder builder) {
        AdvancedCache<?, ?> cache = this.lookupCacheWithStats(request, builder);
        if (builder.getStatus() != HttpResponseStatus.OK.code()) {
            return null;
        }
        return ComponentRegistryUtils.getQueryStatistics(cache);
    }
}

