/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.group.ChannelMatcher;
import io.netty.handler.codec.http.cors.CorsConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.CorsUtil;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.RestChannelInitializer;
import org.infinispan.rest.RestRequestHandler;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.AuthenticationConfiguration;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.ResourceManager;
import org.infinispan.rest.framework.RestDispatcher;
import org.infinispan.rest.framework.impl.ResourceManagerImpl;
import org.infinispan.rest.framework.impl.RestDispatcherImpl;
import org.infinispan.rest.resources.CacheManagerResource;
import org.infinispan.rest.resources.CacheResourceV2;
import org.infinispan.rest.resources.ClusterResource;
import org.infinispan.rest.resources.CounterResource;
import org.infinispan.rest.resources.LoggingResource;
import org.infinispan.rest.resources.MetricsResource;
import org.infinispan.rest.resources.ProtobufResource;
import org.infinispan.rest.resources.RedirectResource;
import org.infinispan.rest.resources.SearchAdminResource;
import org.infinispan.rest.resources.SecurityResource;
import org.infinispan.rest.resources.ServerResource;
import org.infinispan.rest.resources.StaticContentResource;
import org.infinispan.rest.resources.TasksResource;
import org.infinispan.rest.resources.XSiteResource;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;

public class RestServer
extends AbstractProtocolServer<RestServerConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(RestServer.class, Log.class);
    private static final int CROSS_ORIGIN_ALT_PORT = 9000;
    private RestDispatcher restDispatcher;
    private RestCacheManager<Object> restCacheManager;
    private InvocationHelper invocationHelper;
    private volatile List<CorsConfig> corsRules;
    private volatile int maxContentLength;

    public RestServer() {
        super("REST");
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{this.getRestChannelInitializer()});
    }

    public ChannelMatcher getChannelMatcher() {
        return channel -> channel.pipeline().get(RestRequestHandler.class) != null;
    }

    public RestChannelInitializer getRestChannelInitializer() {
        return new RestChannelInitializer(this, this.transport);
    }

    RestDispatcher getRestDispatcher() {
        return this.restDispatcher;
    }

    public void stop() {
        AuthenticationConfiguration auth;
        if (log.isDebugEnabled()) {
            log.debugf("Stopping server %s listening at %s:%d", (Object)this.getQualifiedName(), (Object)((RestServerConfiguration)this.configuration).host(), (Object)((RestServerConfiguration)this.configuration).port());
        }
        if (this.restCacheManager != null) {
            this.restCacheManager.stop();
        }
        if ((auth = ((RestServerConfiguration)this.configuration).authentication()).enabled()) {
            try {
                auth.authenticator().close();
            }
            catch (IOException e) {
                log.trace((Object)e);
            }
        }
        super.stop();
    }

    protected void startInternal() {
        this.maxContentLength = ((RestServerConfiguration)this.configuration).maxContentLength() + 4096 + 8192;
        AuthenticationConfiguration auth = ((RestServerConfiguration)this.configuration).authentication();
        if (auth.enabled()) {
            auth.authenticator().init(this);
        }
        super.startInternal();
        this.restCacheManager = new RestCacheManager(this.cacheManager, arg_0 -> ((RestServer)this).isCacheIgnored(arg_0));
        this.invocationHelper = new InvocationHelper(this, this.restCacheManager, (EmbeddedCounterManager)EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager), (RestServerConfiguration)this.configuration, this.server, this.getExecutor());
        String restContext = ((RestServerConfiguration)this.configuration).contextPath();
        String rootContext = "/";
        ResourceManagerImpl resourceManager = new ResourceManagerImpl();
        resourceManager.registerResource(restContext, new CacheResourceV2(this.invocationHelper));
        resourceManager.registerResource(restContext, new CounterResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new CacheManagerResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new XSiteResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new SearchAdminResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new TasksResource(this.invocationHelper));
        resourceManager.registerResource(restContext, new ProtobufResource(this.invocationHelper));
        resourceManager.registerResource(rootContext, new MetricsResource(auth.metricsAuth(), this.invocationHelper.getExecutor()));
        Path staticResources = ((RestServerConfiguration)this.configuration).staticResources();
        if (staticResources != null) {
            Path console = ((RestServerConfiguration)this.configuration).staticResources().resolve("console");
            resourceManager.registerResource(rootContext, new StaticContentResource(staticResources, "static"));
            resourceManager.registerResource(rootContext, new StaticContentResource(console, "console", (path, resource) -> {
                if (!path.contains(".")) {
                    return "index.html";
                }
                return path;
            }));
            resourceManager.registerResource(rootContext, new RedirectResource(rootContext, rootContext + "console/welcome", true));
        }
        if (this.server != null) {
            resourceManager.registerResource(restContext, new ServerResource(this.invocationHelper));
            resourceManager.registerResource(restContext, new ClusterResource(this.invocationHelper));
            resourceManager.registerResource(restContext, new SecurityResource(this.invocationHelper, rootContext + "console/", rootContext + "console/forbidden.html"));
            this.registerLoggingResource(resourceManager, restContext);
        }
        this.restDispatcher = new RestDispatcherImpl(resourceManager, this.restCacheManager.getAuthorizer());
    }

    private void registerLoggingResource(ResourceManager resourceManager, String restContext) {
        String includeLoggingResource = System.getProperty("infinispan.server.resource.logging", "true");
        if (Boolean.parseBoolean(includeLoggingResource)) {
            resourceManager.registerResource(restContext, new LoggingResource(this.invocationHelper));
        }
    }

    public int maxContentLength() {
        return this.maxContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CorsConfig> getCorsConfigs() {
        List<CorsConfig> rules = this.corsRules;
        if (rules == null) {
            RestServer restServer = this;
            synchronized (restServer) {
                rules = this.corsRules;
                if (rules == null) {
                    rules = new ArrayList<CorsConfig>();
                    rules.addAll(CorsUtil.enableAllForSystemConfig());
                    rules.addAll(CorsUtil.enableAllForLocalHost(this.getPort(), 9000));
                    rules.addAll(((RestServerConfiguration)this.getConfiguration()).getCorsRules());
                    this.corsRules = rules;
                }
            }
        }
        return this.corsRules;
    }
}

