/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.util.CharsetUtil;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.util.Util;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.Http2Test")
public final class Http2Test
extends AbstractInfinispanTest {
    private static final String KEY_STORE_PATH = Http2Test.class.getClassLoader().getResource("./client.p12").getPath();
    private RestClient client;
    private RestServerHelper restServer;

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        if (this.restServer != null) {
            this.restServer.stop();
        }
        Util.close((AutoCloseable)this.client);
    }

    @Test
    public void shouldUseHTTP1WithALPN() {
        this.secureUpgradeTest(Protocol.HTTP_11);
    }

    @Test
    public void shouldUseHTTP2WithALPN() {
        this.secureUpgradeTest(Protocol.HTTP_20);
    }

    @Test
    public void shouldUseHTTP2WithUpgrade() {
        this.clearTextUpgrade(false);
    }

    @Test
    public void shouldUseHTTP2WithPriorKnowledge() {
        this.clearTextUpgrade(true);
    }

    @Test
    public void shouldReportErrorCorrectly() {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withKeyStore(KEY_STORE_PATH, RestServerHelper.STORE_PASSWORD, "pkcs12").withTrustStore(KEY_STORE_PATH, RestServerHelper.STORE_PASSWORD, "pkcs12").start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder config = new RestClientConfigurationBuilder();
        config.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(Protocol.HTTP_20).priorKnowledge(true).security().ssl().enable().trustStoreFileName(KEY_STORE_PATH).trustStorePassword(RestServerHelper.STORE_PASSWORD).trustStoreType("pkcs12").keyStoreFileName(KEY_STORE_PATH).keyStorePassword(RestServerHelper.STORE_PASSWORD).keyStoreType("pkcs12").hostnameVerifier((hostname, session) -> true);
        this.client = RestClient.forConfiguration((RestClientConfiguration)config.build());
        CompletionStage response = this.client.raw().get("/invalid");
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldUseHTTP1() {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(Protocol.HTTP_11);
        this.client = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        CompletionStage response = this.client.cacheManager("default").info();
        ResponseAssertion.assertThat(response).isOk();
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"test".getBytes(CharsetUtil.UTF_8));
        response = this.client.cache("defaultcache").put("test", value);
        Assertions.assertThat((int)((RestResponse)CompletionStages.join((CompletionStage)response)).getStatus()).isEqualTo(204);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }

    private void clearTextUpgrade(boolean previousKnowledge) {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).priorKnowledge(previousKnowledge).protocol(Protocol.HTTP_20);
        this.client = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        CompletionStage response = this.client.cacheManager("default").info();
        ResponseAssertion.assertThat(response).isOk();
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"test".getBytes(CharsetUtil.UTF_8));
        response = this.client.cache("defaultcache").post("test", value);
        Assertions.assertThat((int)((RestResponse)CompletionStages.join((CompletionStage)response)).getStatus()).isEqualTo(204);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }

    private void secureUpgradeTest(Protocol choice) {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withKeyStore(KEY_STORE_PATH, RestServerHelper.STORE_PASSWORD, "pkcs12").start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(choice).security().ssl().trustStoreFileName(KEY_STORE_PATH).trustStorePassword(RestServerHelper.STORE_PASSWORD).hostnameVerifier((hostname, session) -> true);
        this.client = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"test".getBytes(CharsetUtil.UTF_8));
        CompletionStage response = this.client.cache("defaultcache").post("test", value);
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }
}

