/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import java.util.concurrent.CompletionStage;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.test.skip.StringLogAppender;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.RestAccessLoggingTest")
public class RestAccessLoggingTest
extends SingleCacheManagerTest {
    private static final String LOG_FORMAT = "%X{address} %X{user} [%d{dd/MMM/yyyy:HH:mm:ss Z}] \"%X{method} %m %X{protocol}\" %X{status} %X{requestSize} %X{responseSize} %X{duration} %X{h:User-Agent}";
    private StringLogAppender logAppender;
    private String testShortName;
    private RestServerHelper restServer;
    private RestClient restClient;
    private RestCacheClient cacheClient;

    protected EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager();
    }

    protected void setup() throws Exception {
        super.setup();
        this.testShortName = TestResourceTracker.getCurrentTestShortName();
        this.logAppender = new StringLogAppender("org.infinispan.REST_ACCESS_LOG", Level.TRACE, t -> t.getName().startsWith("REST-" + this.testShortName + "-ServerIO-"), (Layout)PatternLayout.newBuilder().withPattern(LOG_FORMAT).build());
        this.logAppender.install();
        this.restServer = new RestServerHelper(this.cacheManager);
        this.restServer.start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort());
        this.restClient = RestClient.forConfiguration((RestClientConfiguration)builder.create());
        this.cacheClient = this.restClient.cache("default");
    }

    protected void teardown() {
        try {
            this.logAppender.uninstall();
            this.restClient.close();
            this.restServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.teardown();
    }

    public void testRestAccessLog() {
        CompletionStages.join((CompletionStage)this.cacheClient.put("key", "value"));
        this.restServer.stop();
        String logline = this.logAppender.getLog(0);
        AssertJUnit.assertTrue((String)logline, (boolean)logline.matches("^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\d+] \"PUT /rest/v2/caches/default/key HTTP/1\\.1\" 404 \\d+ \\d+ \\d+ okhttp/\\p{Graph}+$"));
    }
}

