/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.AdvancedCache;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestRawClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.RestTestSCI;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseCacheResourceTest
extends AbstractRestResourceTest {
    private static final long DEFAULT_LIFESPAN = 45190L;
    private static final long DEFAULT_MAX_IDLE = 1859446L;

    private void defineCounters(EmbeddedCacheManager cm) {
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cm);
        counterManager.defineCounter("weak", CounterConfiguration.builder((CounterType)CounterType.WEAK).build());
        counterManager.defineCounter("strong", CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).build());
    }

    @Override
    protected void defineCaches(EmbeddedCacheManager cm) {
        this.defineCounters(cm);
        ConfigurationBuilder expirationConfiguration = this.getDefaultCacheBuilder();
        expirationConfiguration.expiration().lifespan(45190L).maxIdle(1859446L);
        ConfigurationBuilder xmlCacheConfiguration = this.getDefaultCacheBuilder();
        xmlCacheConfiguration.encoding().value().mediaType("application/xml");
        ConfigurationBuilder jsonCacheConfiguration = this.getDefaultCacheBuilder();
        jsonCacheConfiguration.encoding().value().mediaType("application/json");
        ConfigurationBuilder octetStreamCacheConfiguration = this.getDefaultCacheBuilder();
        octetStreamCacheConfiguration.encoding().value().mediaType("application/octet-stream");
        ConfigurationBuilder unknownContentCacheConfiguration = this.getDefaultCacheBuilder();
        unknownContentCacheConfiguration.encoding().value().mediaType("application/unknown");
        ConfigurationBuilder javaSerialized = this.getDefaultCacheBuilder();
        javaSerialized.encoding().value().mediaType("application/x-java-serialized-object");
        ConfigurationBuilder text = this.getDefaultCacheBuilder();
        text.encoding().key().mediaType("text/plain");
        text.encoding().value().mediaType("text/plain");
        ConfigurationBuilder pojoCache = this.getDefaultCacheBuilder();
        pojoCache.encoding().key().mediaType("application/x-java-object");
        pojoCache.encoding().value().mediaType("application/x-java-object");
        cm.defineConfiguration("default", this.getDefaultCacheBuilder().build());
        cm.defineConfiguration("expiration", expirationConfiguration.build());
        cm.defineConfiguration("xml", xmlCacheConfiguration.build());
        cm.defineConfiguration("json", jsonCacheConfiguration.build());
        cm.defineConfiguration("binary", octetStreamCacheConfiguration.build());
        cm.defineConfiguration("unknown", unknownContentCacheConfiguration.build());
        cm.defineConfiguration("serialized", javaSerialized.build());
        cm.defineConfiguration("textCache", text.build());
        cm.defineConfiguration("pojoCache", pojoCache.build());
    }

    public InternalCacheEntry<String, byte[]> getCacheEntry(String cacheName, byte[] key) {
        AdvancedCache cache = this.getCache(cacheName).withStorageMediaType();
        CacheEntry cacheEntry = cache.getCacheEntry((Object)key);
        return (InternalCacheEntry)cacheEntry;
    }

    public AdvancedCache getCache(String cacheName) {
        return this.restServer().getCacheManager().getCache(cacheName, false).getAdvancedCache();
    }

    @Test
    public void shouldGetNonExistingValue() {
        CompletionStage response = this.client.cache("default").get("nonExisting");
        ResponseAssertion.assertThat(response).doesntExist();
    }

    @Test
    public void shouldReturnNotExistingOnWrongContext() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        RestRawClient rawClient = this.client.raw();
        String path = String.format("/wrongContext/%s/%s", "default", "test");
        CompletionStage response = rawClient.get(path);
        ResponseAssertion.assertThat(response).doesntExist();
    }

    @Test
    public void shouldGetAsciiValueStoredInSpecificFormat() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").get("test", "text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldHaveProperEtagWhenGettingValue() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").get("test", "text/plain");
        ResponseAssertion.assertThat(response).hasEtag();
        ResponseAssertion.assertThat(response).hasHeaderMatching("ETag", "-\\d+");
    }

    @Test
    public void shouldReturnExtendedHeaders() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").get("test", "text/plain", true);
        ResponseAssertion.assertThat(response).hasExtendedHeaders();
    }

    @Test
    public void shouldGetUtf8ValueStoredInSpecificFormat() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").get("test", "text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldGetJsonValueStoredInSpecificFormat() throws Exception {
        this.putJsonValueInCache("json", "test", "{\"name\": \"test\"}");
        CompletionStage response = this.client.cache("json").get("test", "application/json");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"name\": \"test\"}");
    }

    @Test
    public void shouldGetXmlValueStoredInSpecificFormat() throws Exception {
        this.putStringValueInCache("xml", "test", "<xml><name>test</name></xml>");
        CompletionStage response = this.client.cache("xml").get("test", "application/xml");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<xml><name>test</name></xml>");
    }

    @Test
    public void shouldGetValueStoredInUnknownFormat() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").get("test");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldGetOctetStreamValueStoredInSpecificFormat() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putBinaryValueInCache("serialized", "test", this.convertToBytes(testClass), MediaType.APPLICATION_SERIALIZED_OBJECT);
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("serialized").get("test"));
        TestClass convertedObject = (TestClass)this.convertFromBytes(response.getBodyAsByteArray());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType(MediaType.APPLICATION_SERIALIZED_OBJECT.toString());
        ResponseAssertion.assertThat(response).hasNoCharset();
        Assertions.assertThat((String)convertedObject.getName()).isEqualTo((Object)"test");
    }

    @Test
    public void shouldConvertExistingObjectToText() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").get("test", "text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldConvertExistingObjectToTextUtf8() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").get("test", "text/plain;charset=UTF-8");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    void putValueInCache(String cacheName, Object key, Object testValue) {
        this.restServer().getCacheManager().getCache(cacheName).getAdvancedCache().put(key, testValue);
    }

    @Test
    public void shouldGetExistingValueWithoutOutputUsingHEAD() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").head("test");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasNoContent();
    }

    private void putInCache(String cacheName, Object key, String keyContentType, String value, String contentType) {
        RestEntity entity = RestEntity.create((MediaType)MediaType.fromString((String)contentType), (String)value);
        CompletionStage response = this.client.cache(cacheName).put(key.toString(), keyContentType, entity);
        ResponseAssertion.assertThat(response).isOk();
    }

    private byte[] convertToBytes(Object object) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(object);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    private <T> T convertFromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            ObjectInputStream in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return (T)object;
        }
    }

    @Test
    public void shouldDeleteExistingValue() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").remove("test");
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer().getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void shouldDeleteExistingValueWithAcceptHeader() throws Exception {
        this.putBinaryValueInCache("serialized", "test", this.convertToBytes(42), MediaType.APPLICATION_SERIALIZED_OBJECT);
        Map<String, String> headers = this.createHeaders(RequestHeader.ACCEPT_HEADER, "application/x-java-serialized-object");
        CompletionStage headResponse = this.client.cache("serialized").head("test", headers);
        ResponseAssertion.assertThat(headResponse).isOk();
        ResponseAssertion.assertThat(headResponse).hasContentType("application/x-java-serialized-object");
        headers = this.createHeaders(RequestHeader.ACCEPT_HEADER, "text/plain;charset=UTF-8");
        CompletionStage response = this.client.cache("serialized").remove("test", headers);
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer().getCacheManager().getCache("binary")).isEmpty();
    }

    @Test
    public void shouldDeleteNonExistingValue() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").remove("doesnt_exist");
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldDeleteEntireCache() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage response = this.client.cache("default").clear();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer().getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void shouldGetAllEntriesFromEmptyCache() {
        CompletionStage response = this.client.cache("default").keys("text/plain; charset=utf-8");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("[]");
    }

    @Test
    public void shouldGetAllEntriesConvertedToJson() throws Exception {
        this.putStringValueInCache("textCache", "key1", "test1");
        this.putStringValueInCache("textCache", "key2", "test2");
        CompletionStage response = this.client.cache("textCache").keys("application/json");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("[\"key2\",\"key1\"]", "[\"key1\",\"key2\"]");
    }

    @Test
    public void shouldAcceptMultipleAcceptHeaderValues() throws Exception {
        this.putStringValueInCache("textCache", "key1", "test1");
        CompletionStage response = this.client.cache("textCache").get("key1", "ignored/wrong , text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test1");
    }

    @Test
    public void shouldNotAcceptUnknownContentType() throws Exception {
        this.putStringValueInCache("default", "key1", "test1");
        CompletionStage response = this.client.cache("default").get("key1", "application/wrong-content-type");
        ResponseAssertion.assertThat(response).isNotAcceptable();
    }

    @Test
    public void shouldNotAcceptUnknownContentTypeWithHead() throws Exception {
        this.putStringValueInCache("default", "key1", "test1");
        Map<String, String> headers = this.createHeaders(RequestHeader.ACCEPT_HEADER, "garbage");
        CompletionStage response = this.client.cache("default").head("key1", headers);
        ResponseAssertion.assertThat(response).isNotAcceptable();
    }

    @Test
    public void shouldNotReturnValueIfSendingCorrectETag() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        RestResponse firstResponse = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").get("test"));
        String etagFromFirstCall = (String)((List)firstResponse.headers().get("ETag")).get(0);
        Map<String, String> headers = this.createHeaders(RequestHeader.IF_NONE_MATCH, etagFromFirstCall);
        CompletionStage secondResponse = this.client.cache("default").get("test", headers);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)etagFromFirstCall).isNotNull()).isNotEmpty();
        ResponseAssertion.assertThat(secondResponse).isNotModified();
    }

    @Test
    public void shouldReturnEntityWhenSendingWrongETag() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        Map<String, String> headers = this.createHeaders(RequestHeader.IF_NONE_MATCH, "Invalid-etag");
        CompletionStage response = this.client.cache("default").get("test", headers);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldPutTextValueInCache() {
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.fromString((String)"text/plain;charset=UTF-8"), (String)"Hey!");
        CompletionStage response = this.client.cache("default").post("test", restEntity);
        ResponseAssertion.assertThat(response).isOk();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("default", "test".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)new String((byte[])cacheEntry.getValue())).isEqualTo((Object)"Hey!");
    }

    @Test
    public void shouldReturnJsonWithDefaultConfig() throws Exception {
        this.putStringValueInCache("textCache", "test", "Hey!");
        CompletionStage getResponse = this.client.cache("textCache").get("test", "application/json");
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).hasReturnedText("\"Hey!\"");
    }

    @Test
    public void shouldPutUnknownFormatValueInCache() {
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.fromString((String)"application/unknown"), (String)"Hey!");
        CompletionStage response = this.client.cache("unknown").post("test", restEntity);
        ResponseAssertion.assertThat(response).isOk();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("unknown", "test".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)new String((byte[])cacheEntry.getValue())).isEqualTo((Object)"Hey!");
    }

    @Test
    public void shouldPutSerializedValueInCache() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        CompletionStage response = this.client.cache("serialized").post("test", RestEntity.create((MediaType)MediaType.APPLICATION_SERIALIZED_OBJECT, (byte[])this.convertToBytes(testClass)));
        ResponseAssertion.assertThat(response).isOk();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("serialized", "test".getBytes());
        TestClass valueFromCache = (TestClass)this.convertFromBytes((byte[])cacheEntry.getValue());
        ResponseAssertion.assertThat(response).hasEtag();
        Assertions.assertThat((String)valueFromCache.getName()).isEqualTo((Object)"test");
    }

    @Test
    public void shouldConflictWhenTryingToReplaceExistingEntryUsingPost() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.fromString((String)"text/plain;charset=UTF-8"), (String)"Hey!");
        CompletionStage response = this.client.cache("default").post("test", restEntity);
        ResponseAssertion.assertThat(response).isConflicted();
    }

    @Test
    public void shouldUpdateEntryWhenReplacingUsingPut() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache("default").put("test", RestEntity.create((MediaType)MediaType.fromString((String)"text/plain;charset=UTF-8"), (String)"Hey!")));
        String valueFromCache = new String((byte[])this.getCacheEntry("default", "test".getBytes()).getValue());
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((String)valueFromCache).isEqualTo((Object)"Hey!");
    }

    @Test
    public void shouldPutEntryWithDefaultTllAndIdleTime() {
        CompletionStage response = this.client.cache("expiration").post("test", "test");
        ResponseAssertion.assertThat(response).isOk();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("expiration", "test".getBytes());
        Metadata metadata = cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(45190L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(1859446L);
    }

    @Test
    public void shouldPutImmortalEntryWithMinusOneTtlAndIdleTime() {
        CompletionStage response = this.client.cache("expiration").put("test", "test", -1L, -1L);
        ResponseAssertion.assertThat(response).isOk();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("expiration", "test".getBytes());
        Metadata metadata = cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(-1L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(-1L);
    }

    @Test
    public void shouldPutImmortalEntryWithZeroTtlAndIdleTime() {
        CompletionStage response = this.client.cache("expiration").post("test", "test", 0L, 0L);
        ResponseAssertion.assertThat(response).isOk();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("expiration", "test".getBytes());
        Metadata metadata = cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(45190L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(1859446L);
    }

    @Test
    public void testErrorPropagation() throws Exception {
        this.putStringValueInCache("xml", "key", "<value/>");
        CompletionStage response = this.client.cache("xml").get("key", "application/json");
        ResponseAssertion.assertThat(response).isNotAcceptable();
        ResponseAssertion.assertThat(response).containsReturnedText("Cannot convert to application/json");
    }

    @Test
    public void shouldPutEntryWithTtlAndIdleTime() {
        CompletionStage response = this.client.cache("expiration").post("test", "test", 50L, 50L);
        ResponseAssertion.assertThat(response).isOk();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("expiration", "test".getBytes());
        Metadata metadata = cacheEntry.getMetadata();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((long)metadata.lifespan()).isEqualTo(50000L);
        Assertions.assertThat((long)metadata.maxIdle()).isEqualTo(50000L);
    }

    @Test
    public void shouldPutLargeObject() {
        byte[] payload = new byte[1000000];
        CompletionStage response = this.client.cache("binary").post("test", RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])payload));
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasEtag();
        InternalCacheEntry<String, byte[]> cacheEntry = this.getCacheEntry("binary", "test".getBytes());
        Assertions.assertThat((int)((byte[])cacheEntry.getValue()).length).isEqualTo(1000000);
    }

    @Test
    public void shouldFailTooLargeObject() {
        byte[] payload = new byte[1100000];
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])payload);
        CompletionStage response = this.client.cache("default").post("test", restEntity);
        ResponseAssertion.assertThat(response).isPayloadTooLarge();
    }

    @Test
    public void testWildcardAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        CompletionStage getResponse = this.client.cache("default").get("test", "*/*");
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).hasReturnedText("test");
    }

    protected RestResponse get(String cacheName, Object key, String keyContentType, String acceptHeader) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (acceptHeader != null) {
            headers.put(RequestHeader.ACCEPT_HEADER.getValue(), acceptHeader);
        }
        if (keyContentType != null) {
            headers.put(RequestHeader.KEY_CONTENT_TYPE_HEADER.getValue(), keyContentType);
        }
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.client.cache(cacheName).get(key.toString(), headers));
        ResponseAssertion.assertThat(response).isOk();
        return response;
    }

    protected RestResponse get(String cacheName, Object key, String acceptHeader) {
        return this.get(cacheName, key, null, acceptHeader);
    }

    @Test
    public void shouldAcceptUrlEncodedContentForDefaultCache() throws Exception {
        String value = "word1 word2";
        String urlEncoded = URLEncoder.encode(value, "UTF-8");
        this.putBinaryValueInCache("default", "test", urlEncoded.getBytes(StandardCharsets.UTF_8), MediaType.APPLICATION_WWW_FORM_URLENCODED);
        RestResponse getResponse = this.get("default", "test", "text/plain");
        ResponseAssertion.assertThat(getResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(getResponse).hasContentType("text/plain");
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithoutAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        RestResponse getResponse = this.get("default", "test", null);
        ResponseAssertion.assertThat(getResponse).hasReturnedText("test");
        ResponseAssertion.assertThat(getResponse).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        RestResponse jsonResponse = this.get("default", "test", "application/json");
        ResponseAssertion.assertThat(jsonResponse).hasReturnedText("\"test\"");
        ResponseAssertion.assertThat(jsonResponse).hasContentType("application/json");
        RestResponse xmlResponse = this.get("default", "test", "text/plain");
        ResponseAssertion.assertThat(xmlResponse).hasReturnedText("test");
        ResponseAssertion.assertThat(xmlResponse).hasContentType("text/plain");
        RestResponse binaryResponse = this.get("default", "test", "application/octet-stream");
        ResponseAssertion.assertThat(binaryResponse).hasReturnedBytes("test".getBytes(StandardCharsets.UTF_8));
        ResponseAssertion.assertThat(binaryResponse).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithBinary() throws Exception {
        TestClass testClass = new TestClass();
        ProtoStreamMarshaller marshaller = TestingUtil.createProtoStreamMarshaller((SerializationContextInitializer)RestTestSCI.INSTANCE);
        byte[] javaSerialized = marshaller.objectToByteBuffer((Object)testClass);
        this.putBinaryValueInCache("default", "test", javaSerialized, MediaType.APPLICATION_OCTET_STREAM);
        RestResponse response = this.get("default", "test", "application/octet-stream");
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
        ResponseAssertion.assertThat(response).hasReturnedBytes(javaSerialized);
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithWildcardAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        RestResponse getResponse = this.get("default", "test", "*/*");
        ResponseAssertion.assertThat(getResponse).isOk();
        ResponseAssertion.assertThat(getResponse).hasReturnedText("test");
        ResponseAssertion.assertThat(getResponse).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldNegotiateFromDefaultCacheWithMultipleAccept() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        RestResponse sameWeightResponse = this.get("default", "test", "text/html,application/xhtml+xml,*/*");
        ResponseAssertion.assertThat(sameWeightResponse).isOk();
        ResponseAssertion.assertThat(sameWeightResponse).hasReturnedText("test");
        ResponseAssertion.assertThat(sameWeightResponse).hasContentType("application/octet-stream");
        RestResponse weightedResponse = this.get("default", "test", "text/plain;q=0.1, application/json;q=0.8, */*;q=0.7");
        ResponseAssertion.assertThat(weightedResponse).isOk();
        ResponseAssertion.assertThat(weightedResponse).hasReturnedText("\"test\"");
        ResponseAssertion.assertThat(weightedResponse).hasContentType("application/json");
    }

    @Test
    public void shouldNegotiateFromJsonCacheWithoutAccept() throws Exception {
        String cacheName = "json";
        String key = "1";
        String value = "{\"id\": 1}";
        this.putJsonValueInCache(cacheName, key, value);
        RestResponse getResponse = this.get(cacheName, key, null);
        ResponseAssertion.assertThat(getResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(getResponse).hasContentType("application/json");
    }

    @Test
    public void shouldNegotiateFromJsonCacheWithAccept() throws Exception {
        String cacheName = "json";
        String key = "1";
        String value = "{\"id\": 1}";
        this.putJsonValueInCache(cacheName, key, value);
        RestResponse jsonResponse = this.get(cacheName, key, "application/json");
        ResponseAssertion.assertThat(jsonResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(jsonResponse).hasContentType("application/json");
        RestResponse textResponse = this.get(cacheName, key, "text/plain");
        ResponseAssertion.assertThat(textResponse).hasReturnedBytes(value.getBytes(StandardCharsets.UTF_8));
        ResponseAssertion.assertThat(textResponse).hasContentType("text/plain");
    }

    @Test
    public void shouldNegotiateFromJsonCacheWithWildcardAccept() throws Exception {
        String cacheName = "json";
        String key = "1";
        String value = "{\"id\": 1}";
        this.putJsonValueInCache(cacheName, key, value);
        RestResponse jsonResponse = this.get(cacheName, key, "*/*");
        ResponseAssertion.assertThat(jsonResponse).isOk();
        ResponseAssertion.assertThat(jsonResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(jsonResponse).hasContentType("application/json");
    }

    @Test
    public void shouldNegotiateFromJsonCacheWithMultipleAccept() throws Exception {
        String cacheName = "json";
        String key = "1";
        String value = "{\"id\": 1}";
        this.putJsonValueInCache(cacheName, key, value);
        RestResponse jsonResponse = this.get(cacheName, key, "text/html,*/*");
        ResponseAssertion.assertThat(jsonResponse).isOk();
        ResponseAssertion.assertThat(jsonResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(jsonResponse).hasContentType("application/json");
        RestResponse binaryResponse = this.get(cacheName, key, "application/xml, text/plain; q=0.71, */*;q=0.7");
        ResponseAssertion.assertThat(binaryResponse).isOk();
        ResponseAssertion.assertThat(binaryResponse).hasReturnedText(value);
        ResponseAssertion.assertThat(binaryResponse).hasContentType("text/plain");
    }

    @Test
    public void shouldNegotiateOnlySupportedFromDefaultCacheWithMultipleAccept() throws Exception {
        String value = "<test/>";
        this.putStringValueInCache("default", "test", value);
        RestResponse getResponse = this.get("default", "test", "text/html, application/xml");
        ResponseAssertion.assertThat(getResponse).hasReturnedText("<test/>");
        ResponseAssertion.assertThat(getResponse).hasContentType("application/xml");
    }

    @Test
    public void shouldHandleInvalidPath() {
        String Url = String.format("/rest/v2/caches/%s", "asdjsad");
        Map<String, String> headers = this.createHeaders(RequestHeader.ACCEPT_HEADER, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        CompletionStage response = this.client.raw().get(Url, headers);
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldHandleIncompletePath() {
        String Url = String.format("/rest/v2/caches/%s?action", "default");
        CompletionStage response = this.client.raw().get(Url);
        ResponseAssertion.assertThat(response).isBadRequest();
    }

    @Test
    public void testIntegerKeysXmlToTextValues() {
        Integer key = 123;
        String keyContentType = "application/x-java-object;type=java.lang.Integer";
        String valueContentType = "application/xml; charset=UTF-8";
        String value = "<root>test</root>";
        this.putInCache("default", key, keyContentType, value, valueContentType);
        RestResponse response = this.get("default", key, keyContentType, "text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void testIntKeysAndJSONToTextValues() {
        Integer key = 1234;
        String keyContentType = "application/x-java-object;type=java.lang.Integer";
        String value = "{\"a\": 1}";
        this.putInCache("default", key, keyContentType, value, "application/json");
        RestResponse response = this.get("default", key, keyContentType, "text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void testIntKeysTextToXMLValues() {
        Integer key = 12345;
        String keyContentType = "application/x-java-object;type=java.lang.Integer";
        String value = "<foo>bar</foo>";
        this.putInCache("default", key, keyContentType, value, "text/plain");
        RestResponse response = this.get("default", key, keyContentType, "application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void testInvalidXMLConversion() throws Exception {
        String key = "invalid-xml-key";
        String invalidXML = "foo";
        this.putInCache("default", key, invalidXML, "text/plain");
        CompletionStage response = this.client.cache("default").get(key, "application/xml");
        ResponseAssertion.assertThat(response).containsReturnedText("<string>foo</string>");
    }

    protected Map<String, String> createHeaders(RequestHeader header, String value) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(header.getValue(), value);
        return headers;
    }
}

