/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.query.Search;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.rest.CacheEntryInputStream;
import org.infinispan.rest.CacheKeyInputStream;
import org.infinispan.rest.EventStream;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.ServerSentEvent;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.BaseCacheResource;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.stats.Stats;
import org.infinispan.upgrade.RollingUpgradeManager;

public class CacheResourceV2
extends BaseCacheResource
implements ResourceHandler {
    private static final int STREAM_BATCH_SIZE = 1000;
    private final EncoderRegistry encoderRegistry;

    public CacheResourceV2(InvocationHelper invocationHelper) {
        super(invocationHelper);
        this.encoderRegistry = SecurityActions.getEncoderRegistry(invocationHelper.getRestCacheManager().getInstance());
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.PUT, Method.POST).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::putValueToCache).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::getCacheValue).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::deleteCacheValue).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("keys").handleWith(this::streamKeys).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("entries").handleWith(this::streamEntries).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("listen").handleWith(this::cacheListen).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}").withAction("config").handleWith(this::getCacheConfig).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("stats").handleWith(this::getCacheStats).invocation().methods(Method.GET).path("/v2/caches/").handleWith(this::getCacheNames).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").handleWith(this::createCache).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}").handleWith(this::removeCache).invocation().method(Method.HEAD).path("/v2/caches/{cacheName}").handleWith(this::cacheExists).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("clear").handleWith(this::clearEntireCache).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("size").handleWith(this::getSize).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("sync-data").handleWith(this::syncData).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("disconnect-source").handleWith(this::disconnectSource).invocation().methods(Method.GET, Method.POST).path("/v2/caches/{cacheName}").withAction("search").permission(AuthorizationPermission.BULK_READ).handleWith(this.queryAction::search).invocation().methods(Method.POST).path("/v2/caches").withAction("toJSON").handleWith(this::convertToJson).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").handleWith(this::getAllDetails).create();
    }

    private CompletionStage<RestResponse> disconnectSource(RestRequest request) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        builder.status(HttpResponseStatus.NO_CONTENT);
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        try {
            upgradeManager.disconnectSource("hotrod");
        }
        catch (Exception e) {
            builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(e.getMessage());
        }
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletionStage<RestResponse> syncData(RestRequest request) {
        int threads;
        int readBatch;
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        String readBatchReq = request.getParameter("read-batch");
        String threadsReq = request.getParameter("threads");
        int n = readBatch = readBatchReq == null ? 10000 : Integer.parseInt(readBatchReq);
        if (readBatch < 1) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).entity(Log.REST.illegalArgument("read-batch", readBatch).getMessage()).build());
        }
        int n2 = threads = request.getParameter("threads") == null ? ProcessorInfo.availableProcessors() : Integer.parseInt(threadsReq);
        if (threads < 1) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).entity(Log.REST.illegalArgument("threads", threads).getMessage()).build());
        }
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        return CompletableFuture.supplyAsync(() -> {
            try {
                long hotrod = upgradeManager.synchronizeData("hotrod", readBatch, threads);
                builder.entity(Log.REST.synchronizedEntries(hotrod));
            }
            catch (Exception e) {
                Throwable rootCause = Util.getRootCause((Throwable)e);
                builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(rootCause.getMessage());
            }
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> convertToJson(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String contents = restRequest.contents().asString();
        if (contents == null || contents.isEmpty()) {
            responseBuilder.status(HttpResponseStatus.BAD_REQUEST);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        ParserRegistry parserRegistry = this.invocationHelper.getParserRegistry();
        ConfigurationBuilderHolder builderHolder = parserRegistry.parse(contents);
        ConfigurationBuilder builder = (ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().values().iterator().next();
        Configuration configuration = builder.build();
        responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(this.invocationHelper.getJsonWriter().toJSON((ConfigurationInfo)configuration));
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> streamKeys(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        String batchParam = request.getParameter("batch");
        String limitParam = request.getParameter("limit");
        int batch = batchParam == null || batchParam.isEmpty() ? 1000 : Integer.parseInt(batchParam);
        int limit = limitParam == null || limitParam.isEmpty() ? -1 : Integer.parseInt(limitParam);
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON, request);
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            CacheStream stream = cache.keySet().stream();
            if (limit > -1) {
                stream = stream.limit((long)limit);
            }
            responseBuilder.entity(new CacheKeyInputStream(stream, batch));
            responseBuilder.contentType("application/json");
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> streamEntries(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        String limitParam = request.getParameter("limit");
        String metadataParam = request.getParameter("metadata");
        String batchParam = request.getParameter("batch");
        String negotiateMediaType = request.getParameter("content-negotiation");
        int limit = limitParam == null ? -1 : Integer.parseInt(limitParam);
        boolean metadata = Boolean.parseBoolean(metadataParam);
        int batch = batchParam == null ? 1000 : Integer.parseInt(batchParam);
        boolean negotiate = Boolean.parseBoolean(negotiateMediaType);
        AdvancedCache cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request).getAdvancedCache();
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        MediaType keyMediaType = negotiate ? this.negotiateEntryMediaType(cache, this.encoderRegistry, true) : MediaType.APPLICATION_JSON;
        MediaType valueMediaType = negotiate ? this.negotiateEntryMediaType(cache, this.encoderRegistry, false) : MediaType.APPLICATION_JSON;
        AdvancedCache<Object, Object> streamCache = this.invocationHelper.getRestCacheManager().getCache(cacheName, keyMediaType, valueMediaType, request);
        return CompletableFuture.supplyAsync(() -> {
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            CacheStream stream = streamCache.entrySet().stream();
            if (limit > -1) {
                stream = stream.limit((long)limit);
            }
            responseBuilder.entity(new CacheEntryInputStream(keyMediaType.match(MediaType.APPLICATION_JSON), valueMediaType.match(MediaType.APPLICATION_JSON), stream, batch, metadata));
            responseBuilder.contentType("application/json");
            responseBuilder.header(ResponseHeader.KEY_CONTENT_TYPE_HEADER.getValue(), keyMediaType.toString());
            responseBuilder.header(ResponseHeader.VALUE_CONTENT_TYPE_HEADER.getValue(), valueMediaType.toString());
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> cacheListen(RestRequest request) {
        MediaType accept = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN);
        String cacheName = request.variables().get("cacheName");
        boolean includeCurrentState = Boolean.parseBoolean(request.getParameter("includeCurrentState"));
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return ResourceUtil.notFoundResponseFuture();
        }
        AdvancedCache<Object, Object> cache = restCacheManager.getCache(cacheName, accept, accept, request);
        BaseCacheListener listener = includeCurrentState ? new StatefulCacheListener((Cache<?, ?>)cache) : new StatelessCacheListener((Cache<?, ?>)cache);
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        responseBuilder.contentType(MediaType.TEXT_EVENT_STREAM).entity(listener.getEventStream());
        return cache.addListenerAsync((Object)listener).thenApply(v -> responseBuilder.build());
    }

    private MediaType negotiateEntryMediaType(AdvancedCache<?, ?> cache, EncoderRegistry encoderRegistry, boolean forKey) {
        boolean textSupported;
        MediaType storage = forKey ? cache.getKeyDataConversion().getStorageMediaType() : cache.getValueDataConversion().getStorageMediaType();
        boolean encodingDefined = !MediaType.APPLICATION_UNKNOWN.equals((Object)storage);
        boolean jsonSupported = encodingDefined && encoderRegistry.isConversionSupported(storage, MediaType.APPLICATION_JSON);
        boolean bl = textSupported = encodingDefined && encoderRegistry.isConversionSupported(storage, MediaType.TEXT_PLAIN);
        if (jsonSupported) {
            return MediaType.APPLICATION_JSON;
        }
        if (textSupported) {
            return MediaType.TEXT_PLAIN;
        }
        if (encodingDefined) {
            return storage.withEncoding("hex");
        }
        return MediaType.APPLICATION_OCTET_STREAM.withEncoding("hex");
    }

    private CompletionStage<RestResponse> removeCache(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return ResourceUtil.notFoundResponseFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            restCacheManager.getCacheManagerAdmin(request).removeCache(cacheName);
            return new NettyRestResponse.Builder().status(HttpResponseStatus.OK).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> cacheExists(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = restRequest.variables().get("cacheName");
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
        } else {
            responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletableFuture<RestResponse> createCache(RestRequest request) {
        MediaType sourceType;
        EmbeddedCacheManagerAdmin administration;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        List<String> template = request.parameters().get("template");
        String cacheName = request.variables().get("cacheName");
        EnumSet<CacheContainerAdmin.AdminFlag> adminFlags = request.getAdminFlags();
        EmbeddedCacheManagerAdmin initialAdmin = this.invocationHelper.getRestCacheManager().getCacheManagerAdmin(request);
        EmbeddedCacheManagerAdmin embeddedCacheManagerAdmin = administration = adminFlags == null ? initialAdmin : (EmbeddedCacheManagerAdmin)initialAdmin.withFlags(adminFlags);
        if (template != null && !template.isEmpty()) {
            String templateName = template.iterator().next();
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, templateName);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        ContentSource contents = request.contents();
        byte[] bytes = contents.rawContent();
        if (bytes == null || bytes.length == 0) {
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, (String)null);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        MediaType mediaType = sourceType = request.contentType() == null ? MediaType.APPLICATION_JSON : request.contentType();
        if (sourceType.match(MediaType.APPLICATION_JSON)) {
            this.invocationHelper.getJsonReader().readJson((ConfigurationBuilderInfo)cfgBuilder, StandardConversions.convertTextToObject((Object)bytes, (MediaType)sourceType));
        } else if (sourceType.match(MediaType.APPLICATION_XML)) {
            ConfigurationBuilderHolder builderHolder = this.invocationHelper.getParserRegistry().parse(new String(bytes, StandardCharsets.UTF_8));
            cfgBuilder = builderHolder.getCurrentConfigurationBuilder();
        } else {
            responseBuilder.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        ConfigurationBuilder finalCfgBuilder = cfgBuilder;
        return CompletableFuture.supplyAsync(() -> {
            try {
                administration.createCache(cacheName, finalCfgBuilder.build());
                responseBuilder.status(HttpResponseStatus.OK);
            }
            catch (Throwable t) {
                responseBuilder.status(HttpResponseStatus.BAD_REQUEST).entity(t.getMessage());
            }
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getCacheStats(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        return CompletableFuture.supplyAsync(() -> ResourceUtil.asJsonResponse(cache.getAdvancedCache().getStats().toJson()), this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getAllDetails(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        return CompletableFuture.supplyAsync(() -> this.getDetailResponse((Cache<?, ?>)cache), this.invocationHelper.getExecutor());
    }

    private RestResponse getDetailResponse(Cache<?, ?> cache) {
        Configuration configuration = SecurityActions.getCacheConfiguration(cache.getAdvancedCache());
        Stats stats = null;
        Boolean rehashInProgress = null;
        Boolean indexingInProgress = null;
        Boolean queryable = null;
        try {
            stats = cache.getAdvancedCache().getStats();
            DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
            rehashInProgress = distributionManager != null && distributionManager.isRehashInProgress();
        }
        catch (SecurityException distributionManager) {
            // empty catch block
        }
        Integer size = null;
        try {
            size = cache.size();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SearchStatistics searchStatistics = Search.getSearchStatistics(cache);
        IndexStatistics indexStatistics = searchStatistics.getIndexStatistics();
        indexingInProgress = indexStatistics.reindexing();
        queryable = this.invocationHelper.getRestCacheManager().isCacheQueryable(cache);
        boolean statistics = configuration.statistics().enabled();
        boolean indexed = configuration.indexing().enabled();
        CacheFullDetail fullDetail = new CacheFullDetail();
        fullDetail.stats = stats;
        fullDetail.configuration = this.invocationHelper.getJsonWriter().toJSON((ConfigurationInfo)configuration);
        fullDetail.size = size;
        fullDetail.rehashInProgress = rehashInProgress;
        fullDetail.indexingInProgress = indexingInProgress;
        fullDetail.persistent = configuration.persistence().usingStores();
        fullDetail.bounded = configuration.memory().whenFull().isEnabled();
        fullDetail.indexed = indexed;
        fullDetail.hasRemoteBackup = configuration.sites().hasEnabledBackups();
        fullDetail.secured = configuration.security().authorization().enabled();
        fullDetail.transactional = configuration.transaction().transactionMode().isTransactional();
        fullDetail.statistics = statistics;
        fullDetail.queryable = queryable;
        return ResourceUtil.addEntityAsJson(fullDetail.toJson(), new NettyRestResponse.Builder()).build();
    }

    private CompletionStage<RestResponse> getCacheConfig(RestRequest request) {
        AdvancedCache<Object, Object> cache;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        MediaType accept = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.APPLICATION_YAML);
        responseBuilder.contentType(accept);
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        if ((cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request)) == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache.getAdvancedCache());
        ParserRegistry registry = new ParserRegistry();
        switch (accept.getTypeSubtype()) {
            case "application/json": {
                responseBuilder.entity(this.invocationHelper.getJsonWriter().toJSON((ConfigurationInfo)cacheConfiguration));
                break;
            }
            default: {
                ByteArrayOutputStream entity = new ByteArrayOutputStream();
                try (ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)entity).withType(accept).build();){
                    registry.serialize(writer, null, Collections.singletonMap(cacheName, cacheConfiguration));
                }
                catch (Exception e) {
                    return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(Util.getRootCause((Throwable)e)).build());
                }
                responseBuilder.entity(entity);
            }
        }
        return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.OK).build());
    }

    private CompletionStage<RestResponse> getSize(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        return cache.sizeAsync().thenApply(size -> ResourceUtil.asJsonResponse(Json.make((Object)size)));
    }

    private CompletionStage<RestResponse> getCacheNames(RestRequest request) throws RestResponseException {
        Collection<String> cacheNames = this.invocationHelper.getRestCacheManager().getCacheNames();
        return ResourceUtil.asJsonResponseFuture(Json.make(cacheNames));
    }

    @Listener(clustered=true)
    public static class StatelessCacheListener
    extends BaseCacheListener {
        public StatelessCacheListener(Cache<?, ?> cache) {
            super(cache);
        }
    }

    @Listener(clustered=true, includeCurrentState=true)
    public static class StatefulCacheListener
    extends BaseCacheListener {
        public StatefulCacheListener(Cache<?, ?> cache) {
            super(cache);
        }
    }

    public static abstract class BaseCacheListener {
        protected final Cache<?, ?> cache;
        protected final EventStream eventStream;

        protected BaseCacheListener(Cache<?, ?> cache) {
            this.cache = cache;
            this.eventStream = new EventStream(null, () -> cache.removeListenerAsync((Object)this));
        }

        public EventStream getEventStream() {
            return this.eventStream;
        }

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntryExpired
        public CompletionStage<Void> onCacheEvent(CacheEntryEvent<?, ?> event) {
            ServerSentEvent sse = new ServerSentEvent(event.getType().name().toLowerCase().replace('_', '-'), new String((byte[])event.getKey()));
            return this.eventStream.sendEvent(sse);
        }
    }

    private static class CacheFullDetail
    implements JsonSerialization {
        public Stats stats;
        public Integer size;
        public String configuration;
        public Boolean rehashInProgress;
        public boolean bounded;
        public boolean indexed;
        public boolean persistent;
        public boolean transactional;
        public boolean secured;
        public boolean hasRemoteBackup;
        public Boolean indexingInProgress;
        public boolean statistics;
        public Boolean queryable;

        private CacheFullDetail() {
        }

        public Json toJson() {
            Json json = Json.object();
            if (this.stats != null) {
                json.set("stats", this.stats.toJson());
            }
            if (this.size != null) {
                json.set("size", (Object)this.size);
            }
            if (this.rehashInProgress != null) {
                json.set("rehash_in_progress", (Object)this.rehashInProgress);
            }
            if (this.indexingInProgress != null) {
                json.set("indexing_in_progress", (Object)this.indexingInProgress);
            }
            if (this.queryable != null) {
                json.set("queryable", (Object)this.queryable);
            }
            return json.set("configuration", Json.factory().raw(this.configuration)).set("bounded", (Object)this.bounded).set("indexed", (Object)this.indexed).set("persistent", (Object)this.persistent).set("transactional", (Object)this.transactional).set("secured", (Object)this.secured).set("has_remote_backup", (Object)this.hasRemoteBackup).set("statistics", (Object)this.statistics);
        }
    }
}

