/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.ConvertUtil;
import org.infinispan.counter.configuration.StrongCounterConfigurationBuilder;
import org.infinispan.counter.configuration.WeakCounterConfigurationBuilder;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.ResourceUtil;

public class CounterResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final EmbeddedCounterManager counterManager;

    public CounterResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        this.counterManager = invocationHelper.getCounterManager();
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.POST).path("/v2/counters/{counterName}").handleWith(this::createCounter).invocation().methods(Method.DELETE).path("/v2/counters/{counterName}").handleWith(this::deleteCounter).invocation().methods(Method.GET).path("/v2/counters/{counterName}/config").handleWith(this::getConfig).invocation().methods(Method.GET).path("/v2/counters/").handleWith(this::getCounterNames).invocation().methods(Method.GET).path("/v2/counters/{counterName}").handleWith(this::getCounter).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("reset").handleWith(this::resetCounter).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("increment").handleWith(this::incrementCounter).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("decrement").handleWith(this::decrementCounter).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("add").handleWith(this::addValue).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("compareAndSet").handleWith(this::compareSet).invocation().methods(Method.POST).path("/v2/counters/{counterName}").withAction("compareAndSwap").handleWith(this::compareSwap).create();
    }

    private CompletionStage<RestResponse> createCounter(RestRequest request) throws RestResponseException {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String counterName = request.variables().get("counterName");
        String contents = request.contents().asString();
        if (contents == null || contents.length() == 0) {
            responseBuilder.status(HttpResponseStatus.BAD_REQUEST);
            responseBuilder.entity("Configuration not provided");
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        CounterConfiguration configuration = this.createCounterConfiguration(contents);
        if (configuration == null) {
            responseBuilder.status(HttpResponseStatus.BAD_REQUEST).entity("Invalid configuration");
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return this.counterManager.defineCounterAsync(counterName, configuration).thenApply(r -> responseBuilder.build());
    }

    private CompletionStage<RestResponse> deleteCounter(RestRequest request) {
        String counterName = request.variables().get("counterName");
        EmbeddedCounterManager counterManager = this.invocationHelper.getCounterManager();
        return counterManager.getConfigurationAsync(counterName).thenCompose(configuration -> {
            if (configuration == null) {
                return ResourceUtil.notFoundResponseFuture();
            }
            return CompletableFuture.runAsync(() -> counterManager.undefineCounter(counterName), this.invocationHelper.getExecutor()).thenApply(ignore -> new NettyRestResponse.Builder().status(HttpResponseStatus.NO_CONTENT).build());
        });
    }

    private CompletionStage<RestResponse> getConfig(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String counterName = request.variables().get("counterName");
        return this.invocationHelper.getCounterManager().getConfigurationAsync(counterName).thenApply(cfg -> {
            if (cfg == null) {
                return responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
            }
            AbstractCounterConfiguration parsedConfig = ConvertUtil.configToParsedConfig((String)counterName, (CounterConfiguration)cfg);
            String json = this.invocationHelper.getJsonWriter().toJSON((ConfigurationInfo)parsedConfig);
            return responseBuilder.entity(json).contentType(MediaType.APPLICATION_JSON).build();
        });
    }

    private CompletionStage<RestResponse> getCounter(RestRequest request) throws RestResponseException {
        String counterName = request.variables().get("counterName");
        String accept = request.getAcceptHeader();
        MediaType contentType = accept == null ? MediaType.TEXT_PLAIN : this.negotiateMediaType(accept);
        return this.counterManager.getConfigurationAsync(counterName).thenCompose(configuration -> {
            if (configuration == null) {
                return ResourceUtil.notFoundResponseFuture();
            }
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder().contentType(contentType).header(HttpHeaderNames.CACHE_CONTROL.toString(), CacheControl.noCache());
            CompletionStage<Long> response = configuration.type() == CounterType.WEAK ? this.getWeakCounter(counterName).thenApply(WeakCounter::getValue) : this.getStrongCounter(counterName).thenCompose(StrongCounter::getValue);
            return response.thenApply(v -> responseBuilder.entity(Long.toString(v)).build());
        });
    }

    private CompletionStage<RestResponse> resetCounter(RestRequest request) throws RestResponseException {
        String counterName = request.variables().get("counterName");
        return this.counterManager.getConfigurationAsync(counterName).thenCompose(configuration -> {
            if (configuration == null) {
                return ResourceUtil.notFoundResponseFuture();
            }
            CompletableFuture result = configuration.type() == CounterType.WEAK ? this.counterManager.getWeakCounter(counterName).reset() : this.counterManager.getStrongCounter(counterName).reset();
            return result.thenApply(v -> new NettyRestResponse.Builder().status(HttpResponseStatus.NO_CONTENT).build());
        });
    }

    private CompletionStage<RestResponse> getCounterNames(RestRequest request) throws RestResponseException {
        return ResourceUtil.asJsonResponseFuture(Json.make((Object)this.counterManager.getCounterNames()));
    }

    private CompletionStage<RestResponse> incrementCounter(RestRequest request) {
        return this.executeCommonCounterOp(request, WeakCounter::increment, StrongCounter::incrementAndGet);
    }

    private CompletionStage<RestResponse> decrementCounter(RestRequest request) {
        return this.executeCommonCounterOp(request, WeakCounter::decrement, StrongCounter::decrementAndGet);
    }

    private CompletionStage<RestResponse> addValue(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        Long delta = this.checkForNumericParam("delta", request, responseBuilder);
        if (delta == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return this.executeCommonCounterOp(request, weakCounter -> weakCounter.add(delta.longValue()), strongCounter -> strongCounter.addAndGet(delta.longValue()));
    }

    private CompletionStage<RestResponse> compareSet(RestRequest request) {
        return this.executeCounterCAS(request, StrongCounter::compareAndSet);
    }

    private CompletionStage<RestResponse> compareSwap(RestRequest request) {
        return this.executeCounterCAS(request, StrongCounter::compareAndSwap);
    }

    private CounterConfiguration createCounterConfiguration(String json) {
        Json jsonNode = Json.read((String)json);
        boolean strongCounter = jsonNode.has("strong-counter");
        boolean weakCounter = jsonNode.has("weak-counter");
        if (strongCounter) {
            StrongCounterConfigurationBuilder counterBuilder = new StrongCounterConfigurationBuilder(null);
            this.invocationHelper.getJsonReader().readJson((ConfigurationBuilderInfo)counterBuilder, json);
            return ConvertUtil.parsedConfigToConfig((AbstractCounterConfiguration)counterBuilder.create());
        }
        if (weakCounter) {
            WeakCounterConfigurationBuilder counterBuilder = new WeakCounterConfigurationBuilder(null);
            this.invocationHelper.getJsonReader().readJson((ConfigurationBuilderInfo)counterBuilder, json);
            return ConvertUtil.parsedConfigToConfig((AbstractCounterConfiguration)counterBuilder.create());
        }
        return null;
    }

    private CompletionStage<RestResponse> executeCommonCounterOp(RestRequest request, Function<WeakCounter, CompletionStage<Void>> weakOp, Function<StrongCounter, CompletableFuture<Long>> strongOp) {
        String counterName = request.variables().get("counterName");
        CompletableFuture counterConfigAsync = this.counterManager.getConfigurationAsync(counterName);
        return counterConfigAsync.thenCompose(configuration -> {
            if (configuration == null) {
                return ResourceUtil.notFoundResponseFuture();
            }
            CounterType type = configuration.type();
            if (type == CounterType.WEAK) {
                return this.executeWeakCounterOp(counterName, weakOp);
            }
            return this.executeStrongCounterOp(counterName, strongOp);
        });
    }

    private <T> CompletionStage<RestResponse> executeCounterCAS(RestRequest request, CASInvocation<StrongCounter, Long, Long, CompletableFuture<T>> invocation) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String counterName = request.variables().get("counterName");
        Long expect = this.checkForNumericParam("expect", request, responseBuilder);
        if (expect == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        Long update = this.checkForNumericParam("update", request, responseBuilder);
        if (update == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        CompletionStage<StrongCounter> strongCounter = this.getStrongCounter(counterName);
        return strongCounter.thenCompose(counter -> {
            if (counter == null) {
                responseBuilder.status(HttpResponseStatus.BAD_REQUEST).entity(String.format("Strong counter '%s' not found", counterName));
                return CompletableFuture.completedFuture(responseBuilder.build());
            }
            CompletableFuture opResult = (CompletableFuture)invocation.apply((StrongCounter)counter, expect, update);
            return opResult.thenCompose(value -> ResourceUtil.asJsonResponseFuture(Json.make((Object)value)));
        });
    }

    private CompletionStage<RestResponse> executeStrongCounterOp(String counterName, Function<StrongCounter, CompletableFuture<Long>> op) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        CompletionStage<StrongCounter> strongCounter = this.getStrongCounter(counterName);
        return strongCounter.thenCompose(counter -> {
            if (counter == null) {
                responseBuilder.status(HttpResponseStatus.BAD_REQUEST).entity(String.format("Strong counter '%s' not found", counterName));
                return CompletableFuture.completedFuture(responseBuilder.build());
            }
            return ((CompletableFuture)op.apply((StrongCounter)counter)).thenCompose(value -> ResourceUtil.asJsonResponseFuture(Json.make((Object)value), responseBuilder));
        });
    }

    private CompletionStage<WeakCounter> getWeakCounter(String name) {
        WeakCounter weakCounter = this.counterManager.getCreatedWeakCounter(name);
        if (weakCounter != null) {
            return CompletableFuture.completedFuture(weakCounter);
        }
        return CompletableFuture.supplyAsync(() -> this.counterManager.getWeakCounter(name), this.invocationHelper.getExecutor()).exceptionally(ignore -> null);
    }

    private CompletionStage<StrongCounter> getStrongCounter(String name) {
        StrongCounter strongCounter = this.counterManager.getCreatedStrongCounter(name);
        if (strongCounter != null) {
            return CompletableFuture.completedFuture(strongCounter);
        }
        return CompletableFuture.supplyAsync(() -> this.counterManager.getStrongCounter(name), this.invocationHelper.getExecutor()).exceptionally(ignore -> null);
    }

    private Long checkForNumericParam(String name, RestRequest request, NettyRestResponse.Builder builder) {
        List<String> params = request.parameters().get(name);
        if (params == null || params.size() != 1) {
            builder.status(HttpResponseStatus.BAD_REQUEST).entity(String.format("A single '%s' param must be provided", name));
        } else {
            try {
                return Long.valueOf(params.iterator().next());
            }
            catch (NumberFormatException e) {
                builder.status(HttpResponseStatus.BAD_REQUEST).entity(String.format("Param '%s' must be a number", name));
            }
        }
        return null;
    }

    private CompletionStage<RestResponse> executeWeakCounterOp(String counterName, Function<WeakCounter, CompletionStage<Void>> op) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        CompletionStage<WeakCounter> weakCounter = this.getWeakCounter(counterName);
        return weakCounter.thenCompose(counter -> {
            if (counter == null) {
                responseBuilder.status(HttpResponseStatus.BAD_REQUEST).entity(String.format("Weak counter '%s' not found", counterName));
                return CompletableFuture.completedFuture(responseBuilder.build());
            }
            return ((CompletionStage)op.apply((WeakCounter)counter)).thenCompose(t -> CompletableFuture.completedFuture(responseBuilder.build()));
        });
    }

    private MediaType negotiateMediaType(String accept) {
        return MediaType.parseList((String)accept).filter(t -> t.match(MediaType.TEXT_PLAIN)).findFirst().orElseThrow(() -> Log.REST.unsupportedDataFormat(accept));
    }

    @FunctionalInterface
    static interface CASInvocation<C, A, B, R> {
        public R apply(C var1, A var2, B var3);
    }
}

