/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.distribution;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.rest.distribution.NodeDataDistribution;
import org.infinispan.stats.Stats;

@ProtoTypeId(value=6001)
public class CacheDistributionInfo
implements JsonSerialization,
NodeDataDistribution {
    private final String name;
    private final List<String> addresses;
    private final long memoryEntries;
    private final long totalEntries;

    @ProtoFactory
    public CacheDistributionInfo(String name, List<String> addresses, long memoryEntries, long totalEntries) {
        this.name = name;
        this.addresses = addresses;
        this.memoryEntries = memoryEntries;
        this.totalEntries = totalEntries;
    }

    @Override
    @ProtoField(value=1)
    public String name() {
        return this.name;
    }

    @Override
    @ProtoField(value=2, collectionImplementation=ArrayList.class)
    public List<String> addresses() {
        return this.addresses;
    }

    @ProtoField(value=3, defaultValue="0")
    public long memoryEntries() {
        return this.memoryEntries;
    }

    @ProtoField(value=4, defaultValue="0")
    public long totalEntries() {
        return this.totalEntries;
    }

    public Json toJson() {
        return Json.object().set("node_name", (Object)this.name).set("node_addresses", Json.array((Object[])this.addresses.toArray())).set("memory_entries", (Object)this.memoryEntries).set("total_entries", (Object)this.totalEntries);
    }

    public static CacheDistributionInfo resolve(AdvancedCache<?, ?> cache) {
        Stats stats = cache.getStats();
        CacheManagerInfo manager = cache.getCacheManager().getCacheManagerInfo();
        long inMemory = stats.getApproximateEntriesInMemory();
        long total = stats.getApproximateEntries();
        return new CacheDistributionInfo(manager.getNodeName(), manager.getPhysicalAddressesRaw(), inMemory, total);
    }
}

